/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.logging.adapter.model.internal.parser;

import java.math.BigInteger;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Rule Attribute Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 
 * 			RuleAttributeTypes describe the attributes of a structured type.
 * 			Attributes have a name and a value as well as a set of rules that
 * 			are used to create a value for the attribute.
 * 			
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType#getSubstitutionRule <em>Substitution Rule</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType#getDefaultValue <em>Default Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType#getIndex <em>Index</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType#isUsePreviousMatchSubstitutionAsDefault <em>Use Previous Match Substitution As Default</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage#getRuleAttributeType()
 * @model 
 * @generated
 */
public interface RuleAttributeType extends EObject{
	/**
	 * Returns the value of the '<em><b>Substitution Rule</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Substitution Rule</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Substitution Rule</em>' containment reference list.
	 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage#getRuleAttributeType_SubstitutionRule()
	 * @model type="org.eclipse.hyades.logging.adapter.model.internal.parser.SubstitutionRuleType" containment="true"
	 * @generated
	 */
	EList getSubstitutionRule();

	/**
	 * Returns the value of the '<em><b>Default Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					An optional specification of a default value to be returned if  
	 * 					there is no substitution rule or no successful substitution rules.
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Default Value</em>' attribute.
	 * @see #setDefaultValue(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage#getRuleAttributeType_DefaultValue()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String"
	 * @generated
	 */
	String getDefaultValue();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType#getDefaultValue <em>Default Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Default Value</em>' attribute.
	 * @see #getDefaultValue()
	 * @generated
	 */
	void setDefaultValue(String value);

	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Id</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(BigInteger)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage#getRuleAttributeType_Id()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.Integer"
	 * @generated
	 */
	BigInteger getId();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(BigInteger value);

	/**
	 * Returns the value of the '<em><b>Index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Index</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Index</em>' attribute.
	 * @see #setIndex(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage#getRuleAttributeType_Index()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String"
	 * @generated
	 */
	String getIndex();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType#getIndex <em>Index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Index</em>' attribute.
	 * @see #getIndex()
	 * @generated
	 */
	void setIndex(String value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage#getRuleAttributeType_Name()
	 * @model unique="false" dataType="org.eclipse.emf.ecore.xml.type.String" required="true"
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Use Previous Match Substitution As Default</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * 
	 * 					A boolean indicator of whether a previously parsed value be returned if
	 * 					no substitution rules are successful.
	 * 				
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Use Previous Match Substitution As Default</em>' attribute.
	 * @see #isSetUsePreviousMatchSubstitutionAsDefault()
	 * @see #unsetUsePreviousMatchSubstitutionAsDefault()
	 * @see #setUsePreviousMatchSubstitutionAsDefault(boolean)
	 * @see org.eclipse.hyades.logging.adapter.model.internal.parser.ParserPackage#getRuleAttributeType_UsePreviousMatchSubstitutionAsDefault()
	 * @model unique="false" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.Boolean"
	 * @generated
	 */
	boolean isUsePreviousMatchSubstitutionAsDefault();

	/**
	 * Sets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType#isUsePreviousMatchSubstitutionAsDefault <em>Use Previous Match Substitution As Default</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Use Previous Match Substitution As Default</em>' attribute.
	 * @see #isSetUsePreviousMatchSubstitutionAsDefault()
	 * @see #unsetUsePreviousMatchSubstitutionAsDefault()
	 * @see #isUsePreviousMatchSubstitutionAsDefault()
	 * @generated
	 */
	void setUsePreviousMatchSubstitutionAsDefault(boolean value);

	/**
	 * Unsets the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType#isUsePreviousMatchSubstitutionAsDefault <em>Use Previous Match Substitution As Default</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetUsePreviousMatchSubstitutionAsDefault()
	 * @see #isUsePreviousMatchSubstitutionAsDefault()
	 * @see #setUsePreviousMatchSubstitutionAsDefault(boolean)
	 * @generated
	 */
	void unsetUsePreviousMatchSubstitutionAsDefault();

	/**
	 * Returns whether the value of the '{@link org.eclipse.hyades.logging.adapter.model.internal.parser.RuleAttributeType#isUsePreviousMatchSubstitutionAsDefault <em>Use Previous Match Substitution As Default</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Use Previous Match Substitution As Default</em>' attribute is set.
	 * @see #unsetUsePreviousMatchSubstitutionAsDefault()
	 * @see #isUsePreviousMatchSubstitutionAsDefault()
	 * @see #setUsePreviousMatchSubstitutionAsDefault(boolean)
	 * @generated
	 */
	boolean isSetUsePreviousMatchSubstitutionAsDefault();

} // RuleAttributeType
