/*******************************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.hyades.ui.internal.action;

import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.hyades.ui.internal.extension.NavigatorFilterSet;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

/**
 * A menu item that appears in Hyades navigator view menus,
 * used to enable and disable common navigator filter sets.
 * 
 * @since 3.0
 */
public class CommonNavigatorFilterSetAction extends Action {
	private NavigatorFilterSet _filter;
	private INavigator _navigator;
	
	/**
	 * Constructs a new menu item for the given filter in the
	 * specified navigator.
	 * 
	 * @param filter the filter element this item represents.
	 * @param navigator the navigator that contains the filter set.
	 */
	public CommonNavigatorFilterSetAction(NavigatorFilterSet filter, INavigator navigator) {
		super(HyadesUIPlugin.getString("MENU_FILTERS_HIDE", filter.getLabel()), AS_CHECK_BOX);
		setImageDescriptor(filter.getImageDescriptor());
		_filter = filter;
		_navigator = navigator;
		
		HyadesUIPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent event) {
				if (event != null && event.getProperty() != null)
					if (event.getProperty().equals(get_filter().getPreferenceKey()))
						setChecked(get_filter().isEnabled());
			}
		});
		
		setChecked(_filter.isEnabled());
	}
	
	/**
	 * @see org.eclipse.jface.action.Action#run()
	 */
	public void run() {
		_filter.setEnabled(!_filter.isEnabled());
		_navigator.getViewer().refresh();
	}
    /**
     * This method is not intended to be overridden.
     * @return Returns the _filter.
     */
    protected NavigatorFilterSet get_filter() {
        return _filter;
    }
}
