/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.ui.internal.classloader;

import java.io.FileInputStream;
import java.io.InputStream;

import org.eclipse.hyades.ui.internal.util.FileUtil;

public class FileClassLoader
extends AbstractClassLoader
{
	private String fileDir;

	/**
	 * Example:
	 * 		class: z:\temp\myClass\test\AClass.class
	 * 		filePrefix = z:\\temp\\myClass
	 * 		className = test.AClass.class
	 */
	public FileClassLoader(String fileDir)
	{
		super();
		this.fileDir = fileDir;
	}

	public FileClassLoader(ClassLoader parent, String fileDir)
	{
		super(parent);
    	this.fileDir = fileDir;
	}
	
	protected String getFileDir()
	{
		return fileDir;
	}
	
	protected byte[] loadFileBytes(String fileName)
	{
		if(fileName == null)
			return null;
			
    	try
    	{
    		InputStream inputStream = null;
    		try
    		{
	        	inputStream = new FileInputStream(fileName);
	        	byte[] result = new byte[inputStream.available()];
	        	inputStream.read(result);
	        	
	        	return result;
    		}
    		finally
    		{
    			if(inputStream != null)
    				inputStream.close();
    		}
    	}
    	catch(Exception e)
    	{
    	}
    	
    	return null;
	}

	protected byte[] loadClassBytes(String className, String fileDir)
	{
		if(className == null)
			return null;
			
    	className = formatClassName(className);
		
		String fileName = null;
		if(fileDir != null)
		{
    		fileName = FileUtil.appendPath(fileDir, className);
		}
    	else
    	{
    		fileName = className;
    	}
    		
    	return loadFileBytes(fileName);   		
	}
	
	protected byte[] loadClassBytes(String className)
	{
		return loadClassBytes(className, fileDir);
	}
}