/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.internal.navigator;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.views.framelist.FrameList;

/**
 * Extension of the <code>INavigator</code> interface to simplify the creation of 
 * tree navigators.
 * 
 * @author marcelop
 * @since 0.2.0
 */
public interface ITreeNavigator 
extends INavigator
{
	/**
	 * Returns this navigator's tree viewer.
	 * @return StructuredViewer
	 */
	public TreeViewer getTreeViewer();
	
	/**
	 * Returns the working set for this view or <code>null</code> if none is 
	 * defined.
	 * @return IWorkingSet
	 */
	public IWorkingSet getWorkingSet();
	
	/**
	 * Sets the working set for this view, or <code>null</code> to clear it.
	 * @param workingSet the working set, or <code>null</code> to clear it
	 */
	public void setWorkingSet(IWorkingSet workingSet);
	
	/**
	 * Returns the name for the given element to be used as the name for the 
	 * current frame. 
	 * @param element
	 * @return String
	 */
	public String getFrameName(Object element);
	
	/**
	 * Returns the tool tip text for the given element to be used as the tool tip
	 * text for the current frame, and for the view title tooltip.
	 * @param element
	 * @return String
	 */
	public String getFrameToolTipText(Object element);
	
	/**
	 * Returns the frame list for this navigator.
	 * @return FrameList
	 */
	public FrameList getFrameList();
}
