/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.ui.util;

/**
 * Interface for objects that have resources to be free up when they are
 * not required.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public interface IDisposable
{
	/**
	 * Disposes any resource used by this object. There are no guarantees that 
	 * this method is invoked by this object's container or by the Hyades framework.
	 */
	public void dispose();
}
