/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.ui.datapool.internal.util;

import java.util.Enumeration;


/**
 * @author psun
 *
 */
public class CSVTokenizer implements Enumeration
{
	private static final char DOUBLEQUOTE = '"';
	private static final char COMMA = ',';
	private static final String TWOQUOTES = "\"\""; //$NON-NLS-1$
	private static final String QUOTE = "\""; //$NON-NLS-1$
		
	String input = null;
	String nextToken = null;
	public CSVTokenizer(String input)
	{
		this.input = input;
		setNextToken();
	}
	
	public String nextToken()
	{
		String returnToken = processToken(nextToken);
		setNextToken();
		return returnToken;	
	}
	
	private void setNextToken()
	{
		if(input == null)
		{
			nextToken = null;
			return;
		}
		String preprocessedToken = null;
		int quoteIndex = input.indexOf(DOUBLEQUOTE);
		int commaIndex = input.indexOf(COMMA);
		if(commaIndex == -1)
		{
			nextToken = input;
			input = null;
			return;
		}
		if(quoteIndex != -1 && quoteIndex < commaIndex)
		{
			int quoteCount = 1;
			boolean inQuoteRegion = true;
			while(inQuoteRegion)
			{
				// find next comma...if comma is in quote region, find next comma
				quoteIndex = input.indexOf(DOUBLEQUOTE, quoteIndex + 1);
				if(quoteIndex == -1)
					break;
				while(quoteIndex > commaIndex)
				{
					if(quoteCount%2 == 1)
						commaIndex = input.indexOf(COMMA, commaIndex + 1);
					else
					{
						inQuoteRegion = false;
						break;
					}
				}					
				quoteCount++;
			}
		}

		nextToken = input.substring(0, commaIndex);
		input = input.substring(commaIndex + 1);

	}
	
	public boolean hasMoreTokens()
	{
		if(nextToken != null)
			return true;
		else
			return false;
	}

	public boolean hasMoreElements() {
		return hasMoreTokens();
	}

	public Object nextElement() {
		return nextToken();
	}
	
	private String processToken(String preprocessedToken)
	{
		String returnToken = null;
		returnToken = preprocessedToken.trim();
		returnToken = returnToken.replaceAll(TWOQUOTES, QUOTE);
		returnToken = unwrapString(returnToken);
		return returnToken;
	}
	
	private String unwrapString(String value)
	{
		if(value == null || value.length() < 2)
			return value;

		int lastIndex = value.length() - 1;
		if(value.charAt(0) == DOUBLEQUOTE && value.charAt(lastIndex) == DOUBLEQUOTE)
			return value.substring(1, lastIndex);
		else
			return value;
	}
}
