package org.eclipse.hyades.logging.events.cbe;

import java.io.Serializable;

import org.eclipse.emf.ecore.EObject;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Situation</b></em>'.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.Situation#getCategoryName <em>Category Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.Situation#getSituationType <em>Situation Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getSituation()
 * @model 
 * @generated
 */
public interface Situation extends EObject, Serializable {

    /**
     * Value for the '<em><b>Category Name</b></em>' attribute.
     * 
     * @see #getCategoryName() 
     */
    String START_SITUATION_CATEGORY = "StartSituation";

    /**
     * Value for the '<em><b>Category Name</b></em>' attribute.
     * 
     * @see #getCategoryName() 
     */
    String STOP_SITUATION_CATEGORY = "StopSituation";

    /**
     * Value for the '<em><b>Category Name</b></em>' attribute.
     * 
     * @see #getCategoryName() 
     */
    String CONNECT_SITUATION_CATEGORY = "ConnectSituation";

    /**
     * Value for the '<em><b>Category Name</b></em>' attribute.
     * 
     * @see #getCategoryName() 
     */
    String CONFIGURE_SITUATION_CATEGORY = "ConfigureSituation";

    /**
     * Value for the '<em><b>Category Name</b></em>' attribute.
     * 
     * @see #getCategoryName() 
     */
    String REQUEST_SITUATION_CATEGORY = "RequestSituation";

    /**
     * Value for the '<em><b>Category Name</b></em>' attribute.
     * 
     * @see #getCategoryName() 
     */
    String FEATURE_SITUATION_CATEGORY = "FeatureSituation";

    /**
     * Value for the '<em><b>Category Name</b></em>' attribute.
     * 
     * @see #getCategoryName() 
     */
    String DEPENDENCY_SITUATION_CATEGORY = "DependencySituation";

    /**
     * Value for the '<em><b>Category Name</b></em>' attribute.
     * 
     * @see #getCategoryName() 
     */
    String CREATE_SITUATION_CATEGORY = "CreateSituation";

    /**
     * Value for the '<em><b>Category Name</b></em>' attribute.
     * 
     * @see #getCategoryName() 
     */
    String DESTROY_SITUATION_CATEGORY = "DestroySituation";

    /**
     * Value for the '<em><b>Category Name</b></em>' attribute.
     * 
     * @see #getCategoryName() 
     */
    String REPORT_SITUATION_CATEGORY = "ReportSituation";

    /**
     * Value for the '<em><b>Category Name</b></em>' attribute.
     * 
     * @see #getCategoryName() 
     */
    String AVAILABLE_SITUATION_CATEGORY = "AvailableSituation";

    /**
     * Value for the '<em><b>Category Name</b></em>' attribute.
     * 
     * @see #getCategoryName() 
     */
    String OTHER_SITUATION_CATEGORY = "OtherSituation";

    /**
     * Sets the value of the situation type as an Available Situation.
     * <P>
     * It also changes the '<em><b>categoryName</b></em>' attribute to {@link
     * #AVAILABLE_SITUATION_CATEGORY}.
     * </p>
     * 
     * @param reasoningScope reasoning scope for the situation.
     * @param availabilityDisposition  
     *                       availability disposition for the situation.
     * @param operationDisposition
     *                       operation disposition for the situation.
     * @param processingDisposition
     *                       processing disposition for the situation.
     */
    void setAvailableSituation(String reasoningScope, String availabilityDisposition, String operationDisposition, String processingDisposition);

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.Situation#getCategoryName <em>Category Name</em>}' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Category Name</em>' attribute.
     * @see #getCategoryName()
     * @generated
     */
    void setCategoryName(String value);

    /**
     * <p>
     * Returns the value of the '<em><b>Category Name</b></em>' attribute.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Category Name</em>' attribute.
     * @see #setCategoryName(String)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getSituation_CategoryName()
     * @model required="true"
     * @generated
     */
    String getCategoryName();

    /**
     * Sets the value of the situation type as a Configure Situation.
     *
     * <P>
     * It also changes the '<em><b>categoryName</b></em>' attribute to {@link
     * #CONFIGURE_SITUATION_CATEGORY}.
     * </p>
     * 
     * @param reasoningScope reasoning scope for the situation.
     * @param successDisposition
     *                       success disposition for the new situation.
     */
    void setConfigureSituation(String reasoningScope, String successDisposition);

    /**
     * Sets the value of the situation type as a Connect Situation.
     *
     * <P>
     * It also changes the '<em><b>categoryName</b></em>' attribute to {@link
     * #CONNECT_SITUATION_CATEGORY}.
     * </p>
     * 
     * @param reasoningScope reasoning scope for the situation.
     * @param situationDisposition
     *                       situation disposition for the new situation.
     * @param successDisposition
     *                       success disposition for the new situation.
     */
    void setConnectSituation(String reasoningScope, String situationDisposition, String successDisposition);

    /**
     * Sets the value of the situation type as a Create Situation.
     *
     * <P>
     * It also changes the '<em><b>categoryName</b></em>' attribute to {@link
     * #CREATE_SITUATION_CATEGORY}.
     * </p>
     * 
     * @param reasoningScope reasoning scope for the situation.
     * @param successDisposition
     *                       success disposition for the new situation.
     */
    void setCreateSituation(String reasoningScope, String successDisposition);

    /**
     * Sets the value of the situation type as a Dependency Situation.
     *
     * <P>
     * It also changes the '<em><b>categoryName</b></em>' attribute to {@link
     * #DEPENDENCY_SITUATION_CATEGORY}.
     * </p>
     * 
     * @param reasoningScope reasoning scope for the situation.
     * @param dependencyDisposition
     *                       dependency disposition for the new situation.
     */
    void setDependencySituation(String reasoningScope, String dependencyDisposition);

    /**
     * Sets the value of the situation type as a Destroy Situation.
     *
     * <P>
     * It also changes the '<em><b>categoryName</b></em>' attribute to {@link
     * #DESTROY_SITUATION_CATEGORY}.
     * </p>
     * 
     * @param reasoningScope reasoning scope for the situation.
     * @param successDisposition 
     *                        success disposition for the new situation.
     */
    void setDestroySituation(String reasoningScope, String successDisposition);

    /**
     * Sets the value of the situation type as a Feature Situation.
     *
     * <P>
     * It also changes the '<em><b>categoryName</b></em>' attribute to {@link
     * #FEATURE_SITUATION_CATEGORY}.
     * </p>
     * 
     * @param reasoningScope reasoning scope for the situation.
     * @param featureDisposition
     *                        feature disposition for the new situation.
     */
    void setFeatureSituation(String reasoningScope, String featureDisposition);

    /**
     * Sets the value of the situation type as an Other Situation.
     *
     * <P>
     * It also changes the '<em><b>categoryName</b></em>' attribute to {@link
     * #OTHER_SITUATION_CATEGORY}.
     * </p>
     * 
     * @param reasoningScope reasoning scope for the situation.
     * @param any
     *                        value for the new situation.
     */
    void setOtherSituation(String reasoningScope, String any);

    /**
     * Sets the value of the situation type as a Report Situation.
     *
     * <P>
     * It also changes the '<em><b>categoryName</b></em>' attribute to {@link
     * #REPORT_SITUATION_CATEGORY}.
     * </p>
     * 
     * @param reasoningScope reasoning scope for the situation.
     * @param reportCategory 
     *                        report category for the new situation.
     */
    void setReportSituation(String reasoningScope, String reportCategory);

    /**
     * Sets the value of the situation type as a Request Situation.
     *
     * <P>
     * It also changes the '<em><b>categoryName</b></em>' attribute to {@link
     * #REQUEST_SITUATION_CATEGORY}.
     * </p>
     * 
     * @param reasoningScope reasoning scope for the situation.
     * @param situationQualifier
     *                        situation qualifier for the new situation.
     * @param successDisposition
     *                        success disposition for the new situation.
     */
    void setRequestSituation(String reasoningScope, String situationQualifier, String successDisposition);

    /**
     * <p>
     * Sets the value of the '{@link org.eclipse.hyades.logging.events.cbe.Situation#getSituationType <em>Situation Type</em>}' containment reference.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Situation Type</em>' containment reference.
     * @see #getSituationType()
     * @generated
     */
    void setSituationType(SituationType value);

    /**
     * <p>
     * Returns the value of the '<em><b>Situation Type</b></em>' containment reference.
     * </p>
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return the value of the '<em>Situation Type</em>' containment reference.
     * @see #setSituationType(SituationType)
     * @see org.eclipse.hyades.logging.events.cbe.EventPackage#getSituation_SituationType()
     * @model containment="true" required="true"
     * @generated
     */
    SituationType getSituationType();

    /**
     * Sets the value of the situation type as a Start Situation.
     *
     * <P>
     * It also changes the '<em><b>categoryName</b></em>' attribute to {@link
     * #START_SITUATION_CATEGORY}.
     * </p>
     * 
     * @param reasoningScope reasoning scope for the situation.
     * @param situationQualifier
     *                        situation qualifier for the new situation.
     * @param successDisposition
     *                        sucess disposition for the new situation.
     */
    void setStartSituation(String reasoningScope, String situationQualifier, String successDisposition);

    /**
     * Sets the value of the situation type as a Stop Situation.
     *
     * <P>
     * It also changes the '<em><b>categoryName</b></em>' attribute to {@link
     * #STOP_SITUATION_CATEGORY}.
     * </p>
     * 
     * @param reasoningScope reasoning scope for the situation.
     * @param situationQualifier
     *                        situation qualifier for the new situation.
     * @param successDisposition
     *                        success disposition for the new situation.
     */
    void setStopSituation(String reasoningScope, String situationQualifier, String successDisposition);

    /**
     * <p>
     * Checks whether the contents of the instance conform to the
     * CBE specification.
     * </p>
     *
     * @throws ValidationException 
     *                       if the event instance does not follow the 
     *                       CBE specification.
     */
    void validate() throws ValidationException;

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    void init();
} // Situation
