package org.eclipse.hyades.logging.events.cbe.impl;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.logging.events.cbe.DestroySituation;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.events.cbe.util.EventValidation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Destroy Situation</b></em>'.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * @implements Cloneable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.DestroySituationImpl#getSuccessDisposition <em>Success Disposition</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DestroySituationImpl extends SituationTypeImpl implements DestroySituation, Cloneable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -6561753088656143510L;

    /**
     * Classname for trace/log 
     */
    private static final String CLASS_NAME = DestroySituationImpl.class.getName();

    /**
     * The default value of the '{@link #getSuccessDisposition() <em>Success Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSuccessDisposition()
     * @generated
     * @ordered
     */
    protected static final String SUCCESS_DISPOSITION_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getSuccessDisposition() <em>Success Disposition</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSuccessDisposition()
     * @generated
     * @ordered
     */
    protected String successDisposition = SUCCESS_DISPOSITION_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DestroySituationImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getDestroySituation();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getSuccessDisposition() {
        return successDisposition;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setSuccessDisposition(String newSuccessDisposition) {
        String oldSuccessDisposition = successDisposition;
        successDisposition = newSuccessDisposition;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.DESTROY_SITUATION__SUCCESS_DISPOSITION, oldSuccessDisposition, successDisposition));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.DESTROY_SITUATION__REASONING_SCOPE :
                return getReasoningScope();
            case EventPackage.DESTROY_SITUATION__SUCCESS_DISPOSITION :
                return getSuccessDisposition();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.DESTROY_SITUATION__REASONING_SCOPE :
                setReasoningScope((String) newValue);
                return;
            case EventPackage.DESTROY_SITUATION__SUCCESS_DISPOSITION :
                setSuccessDisposition((String) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.DESTROY_SITUATION__REASONING_SCOPE :
                setReasoningScope(REASONING_SCOPE_EDEFAULT);
                return;
            case EventPackage.DESTROY_SITUATION__SUCCESS_DISPOSITION :
                setSuccessDisposition(SUCCESS_DISPOSITION_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.DESTROY_SITUATION__REASONING_SCOPE :
                return REASONING_SCOPE_EDEFAULT == null ? reasoningScope != null : !REASONING_SCOPE_EDEFAULT.equals(reasoningScope);
            case EventPackage.DESTROY_SITUATION__SUCCESS_DISPOSITION :
                return SUCCESS_DISPOSITION_EDEFAULT == null ? successDisposition != null : !SUCCESS_DISPOSITION_EDEFAULT.equals(successDisposition);
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (successDisposition: ");
        result.append(successDisposition);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the
     * CBE specification.
     *
     * @throws ValidationException 
     *                       if the event instance does not follow the 
     *                       CBE specification.
     */
    public void validate() throws ValidationException {

        // checking super class 
        super.validate();

        // parent class already checked for required attributes
        //EventValidation.validateRequiredAttributes(this};

        // checking for boundaries
        EventPackage ePck = EventPackage.eINSTANCE;
        EAttribute attr = ePck.getDestroySituation_SuccessDisposition();
        EventValidation.validateLength(CLASS_NAME, this, attr, DISPOSITION_MAX_LENGTH);
    }

	/**
	 * return a cloned (copy by value) object. This is a deep copy version, in which all the
	 * objects within this object will be copied by value.
	 *  
	 * @return Object
	 */
	public Object clone() throws CloneNotSupportedException {
		return EcoreUtil.copy(this);
	}

	/**
	 * Overrides the <code>java.lang.Object</code>'s equals() API to 
	 * determine if the parameter <code>object</code> is equal to this object.
	 * 
	 * @param object The <code>java.lang.Object</code> to be compared to this object.
	 * @return true if this object is the same as the parameter <code>object</code>, false otherwise.
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object object) {
		return EventHelpers.compareEObject(this, object);
	}

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        super.init();

        setSuccessDisposition(SUCCESS_DISPOSITION_EDEFAULT);
    }
} //DestroySituationImpl
