package org.eclipse.hyades.logging.events.cbe.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.events.cbe.util.EventMessages;
import org.eclipse.hyades.logging.events.cbe.util.EventValidation;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Extended Data Element</b></em>'.
 *
 * @author Andrea Chiavegatto
 * @author Denilson Nastacio
 * @author Scott Brown
 * @version 1.0.1
 * @since 1.0
 * @implements Cloneable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ExtendedDataElementImpl#getHexValue <em>Hex Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ExtendedDataElementImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ExtendedDataElementImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ExtendedDataElementImpl#getValues <em>Values</em>}</li>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.ExtendedDataElementImpl#getChildren <em>Children</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ExtendedDataElementImpl extends SerializableImpl implements ExtendedDataElement, Cloneable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -6200886839335499445L;

    /**
     * Classname for trace/log
     */
    private static final String CLASS_NAME = ExtendedDataElementImpl.class.getName();

    /** CBE size limit for extended data element type name */
    private static final int MAX_TYPE_LENGTH = 64;

    /** CBE size limit for extended data element names */
    private static final int MAX_NAME_LENGTH = 64;

    /** CBE size limit for each value inside an extended data element. */
    private static final int MAX_VALUE_LENGTH = 1024;

    /**
    * Array of types for the extended data element.
    * 
    * @see #getType()
    */
    public static final String[] EDE_TYPES = { TYPE_NO_VALUE, // 0 
        TYPE_BYTE, // 1
        TYPE_SHORT, // 2
        TYPE_INT, // 3
        TYPE_LONG, // 4
        TYPE_FLOAT, // 5
        TYPE_DOUBLE, // 6
        TYPE_STRING, // 7
        TYPE_DATE_TIME, // 8
        TYPE_BOOLEAN, // 9
        TYPE_BYTE_ARRAY, // 10
        TYPE_SHORT_ARRAY, // 11
        TYPE_INT_ARRAY, // 12
        TYPE_LONG_ARRAY, // 13
        TYPE_FLOAT_ARRAY, // 14
        TYPE_DOUBLE_ARRAY, // 15
        TYPE_STRING_ARRAY, // 16
        TYPE_DATE_TIME_ARRAY, // 17 
        TYPE_BOOLEAN_ARRAY, // 18
        TYPE_HEX_BINARY }; // 19

    public static final List EDE_TYPES_LIST = Arrays.asList(EDE_TYPES);

    /**
     * Support for the getters and setters based on hexadecimal
     * values.
     *
     * @see #getHexValueAsByteArray()
     * @see #setHexValueAsByteArray(byte[])
     */
    private static final char[] HEX_BASE_CHARS = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

    /**
     * The default value of the '{@link #getHexValue() <em>Hex Value</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getHexValue()
     * @generated
     * @ordered
     */
    protected static final String HEX_VALUE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getHexValue() <em>Hex Value</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getHexValue()
     * @generated
     * @ordered
     */
    protected String hexValue = HEX_VALUE_EDEFAULT;

    /**
     * The default value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
    protected static final String NAME_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
    protected String name = NAME_EDEFAULT;

    /**
     * The default value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
    protected static final String TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
    protected String type = TYPE_EDEFAULT;

    /**
     * The cached value of the '{@link #getValues() <em>Values</em>}' attribute list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getValues()
     * @generated
     * @ordered
     */
    protected EList values = null;

    /**
     * The cached value of the '{@link #getChildren() <em>Children</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getChildren()
     * @generated
     * @ordered
     */
    protected EList children = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ExtendedDataElementImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getChildren() {
        if (children == null) {
            children = new EObjectContainmentEList(ExtendedDataElement.class, this, EventPackage.EXTENDED_DATA_ELEMENT__CHILDREN);
        }
        return children;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getChildren(String)
     */
    public EList getChildren(String newName) {
        ListIterator it = getChildren().listIterator();
        BasicEList res = new BasicEList();
        ExtendedDataElement ede = null;
        
        while (it.hasNext()) {
            
            ede = ((ExtendedDataElement) (it.next()));

            if ((ede!= null) && (ede.getName().equals(newName))) {
                res.addUnique(ede);
            }
        }

        return res;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setHexValue(String newHexValue) {
        String oldHexValue = hexValue;
        hexValue = newHexValue;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.EXTENDED_DATA_ELEMENT__HEX_VALUE, oldHexValue, hexValue));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getHexValue() {
        return hexValue;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setHexValueAsByteArray(byte[])
     */
    public void setHexValueAsByteArray(byte[] value) {
        setHexValue(byteArrayToHexBinary(value));
        setType(ExtendedDataElement.TYPE_HEX_BINARY);
    }

    /**
     * Sets the hexValue of the extended data element as an array of chars.
     *
     * <P>
     * It also changes the '<em><b>Type</b></em>' attribute to {@link
     * #TYPE_HEX_BINARY}.
     * </p>
     *
     * @param value the new hexValue for the extended data element.
     */
    public void setHexValueAsCharArray(char[] value) {
        setHexValue(new String(value));
        setType(ExtendedDataElement.TYPE_HEX_BINARY);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getHexValueAsByteArray()
     */
    public byte[] getHexValueAsByteArray() {
        byte[] result = null;

        if (getType().equals(TYPE_HEX_BINARY)) {
            String localHexValue = getHexValue();

            if (localHexValue != null) {
                try {
                    result = hexBinaryToByteArray(localHexValue);
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalStateException(localHexValue + " is not a valid xsd:hexBinary value"); /* NOI18N */
                }
            }

            // if hexValue not null
        }
        else {
            throw new IllegalStateException("type is not hexBinary"); //$NON-NLS-1$
        }

        // if type is right
        return result;
    }

    /**
     * <p>
     * Returns the hexValue of the extended data element cast as char array
     * values.
     * </p>
     *
     * @return the hexValue of the extended data element.
     *
     * @throws IllegalStateException if the '<em><b>Type</b></em>' attribute is
     *         not {@link #TYPE_HEX_BINARY}.
     */
    public char[] getHexValueAsCharArray() {

        char[] result = null;

        if (getType().equals(TYPE_HEX_BINARY)) {

            String localHexValue = getHexValue();

            if (localHexValue != null) {
                try {
                    result = localHexValue.toCharArray();
                }
                catch (IllegalArgumentException ex) {
                    throw new IllegalStateException(localHexValue + " is not a valid xsd:hexBinary value"); /* NOI18N */
                }
            }

            // if hexValue not null
        }
        else {
            throw new IllegalStateException("type is not hexBinary"); //$NON-NLS-1$
        }

        // if type is right
        return result;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setName(String newName) {
        String oldName = name;
        name = newName;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.EXTENDED_DATA_ELEMENT__NAME, oldName, name));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getName() {
        return name;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setType(String newType) {
        String oldType = type;
        type = newType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.EXTENDED_DATA_ELEMENT__TYPE, oldType, type));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getType() {
        return type;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setTypeAsInt(int)
     */
    public void setTypeAsInt(int value) {
        switch (value) {
            case TYPE_BYTE_VALUE :
                setType(TYPE_BYTE);

                break;

            case TYPE_SHORT_VALUE :
                setType(TYPE_SHORT);

                break;

            case TYPE_INT_VALUE :
                setType(TYPE_INT);

                break;

            case TYPE_LONG_VALUE :
                setType(TYPE_LONG);

                break;

            case TYPE_FLOAT_VALUE :
                setType(TYPE_FLOAT);

                break;

            case TYPE_DOUBLE_VALUE :
                setType(TYPE_DOUBLE);

                break;

            case TYPE_STRING_VALUE :
                setType(TYPE_STRING);

                break;

            case TYPE_DATE_TIME_VALUE :
                setType(TYPE_DATE_TIME);

                break;

            case TYPE_BOOLEAN_VALUE :
                setType(TYPE_BOOLEAN);

                break;

            case TYPE_BYTE_ARRAY_VALUE :
                setType(TYPE_BYTE_ARRAY);

                break;

            case TYPE_SHORT_ARRAY_VALUE :
                setType(TYPE_SHORT_ARRAY);

                break;

            case TYPE_INT_ARRAY_VALUE :
                setType(TYPE_INT_ARRAY);

                break;

            case TYPE_LONG_ARRAY_VALUE :
                setType(TYPE_LONG_ARRAY);

                break;

            case TYPE_FLOAT_ARRAY_VALUE :
                setType(TYPE_FLOAT_ARRAY);

                break;

            case TYPE_DOUBLE_ARRAY_VALUE :
                setType(TYPE_DOUBLE_ARRAY);

                break;

            case TYPE_STRING_ARRAY_VALUE :
                setType(TYPE_STRING_ARRAY);

                break;

            case TYPE_DATE_TIME_ARRAY_VALUE :
                setType(TYPE_DATE_TIME_ARRAY);

                break;

            case TYPE_BOOLEAN_ARRAY_VALUE :
                setType(TYPE_BOOLEAN_ARRAY);

                break;

            case TYPE_HEX_BINARY_VALUE :
                setType(TYPE_HEX_BINARY);

                break;

            default : // TYPE_NO_VALUE_VALUE or others
                setType(TYPE_NO_VALUE);

                break;
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getTypeAsInt()
     */
    public int getTypeAsInt() {
        String t = getType();

        if (t != null) {
            if (t.equals(TYPE_BYTE)) {
                return TYPE_BYTE_VALUE;
            }

            if (t.equals(TYPE_SHORT)) {
                return TYPE_SHORT_VALUE;
            }

            if (t.equals(TYPE_INT)) {
                return TYPE_INT_VALUE;
            }

            if (t.equals(TYPE_LONG)) {
                return TYPE_LONG_VALUE;
            }

            if (t.equals(TYPE_FLOAT)) {
                return TYPE_FLOAT_VALUE;
            }

            if (t.equals(TYPE_DOUBLE)) {
                return TYPE_DOUBLE_VALUE;
            }

            if (t.equals(TYPE_STRING)) {
                return TYPE_STRING_VALUE;
            }

            if (t.equals(TYPE_DATE_TIME)) {
                return TYPE_DATE_TIME_VALUE;
            }

            if (t.equals(TYPE_BOOLEAN)) {
                return TYPE_BOOLEAN_VALUE;
            }

            if (t.equals(TYPE_BYTE_ARRAY)) {
                return TYPE_BYTE_ARRAY_VALUE;
            }

            if (t.equals(TYPE_SHORT_ARRAY)) {
                return TYPE_SHORT_ARRAY_VALUE;
            }

            if (t.equals(TYPE_INT_ARRAY)) {
                return TYPE_INT_ARRAY_VALUE;
            }

            if (t.equals(TYPE_LONG_ARRAY)) {
                return TYPE_LONG_ARRAY_VALUE;
            }

            if (t.equals(TYPE_FLOAT_ARRAY)) {
                return TYPE_FLOAT_ARRAY_VALUE;
            }

            if (t.equals(TYPE_DOUBLE_ARRAY)) {
                return TYPE_DOUBLE_ARRAY_VALUE;
            }

            if (t.equals(TYPE_STRING_ARRAY)) {
                return TYPE_STRING_ARRAY_VALUE;
            }

            if (t.equals(TYPE_DATE_TIME_ARRAY)) {
                return TYPE_DATE_TIME_ARRAY_VALUE;
            }

            if (t.equals(TYPE_BOOLEAN_ARRAY)) {
                return TYPE_BOOLEAN_ARRAY_VALUE;
            }

            if (t.equals(TYPE_HEX_BINARY)) {
                return TYPE_HEX_BINARY_VALUE;
            }
        }

        return TYPE_NO_VALUE_VALUE;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getValues() {
        if (values == null) {
            values = new EDataTypeEList(String.class, this, EventPackage.EXTENDED_DATA_ELEMENT__VALUES);
        }
        return values;
    }

    /**
     * The array of values for this extended data element as a string representation
     * of the type specified above, excluding hexBinary.  hexBinary values MUST be 
     * defined using the hexValue property.  This is an OPTIONAL property.
     * 
     * @throws InvalidExtendedDataElementTypeException if the extended data element is a hexBinary data type.
     * @param String[] the values to set
     */
    public void setValues(String[] values) {
        EList valueList = resetValues();
        valueList.addAll(Arrays.asList(values));
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsBoolean(boolean)
     */
    public void setValuesAsBoolean(boolean value) {
        setValuesAsString(String.valueOf(value));
        setType(TYPE_BOOLEAN);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsBoolean()
     */
    public boolean getValuesAsBoolean() {
        if (getType().equals(TYPE_BOOLEAN) && (getValues().size() == 1)) {
            return (new Boolean((String) getValues().get(0))).booleanValue();
        }
        else {
            throw new IllegalStateException();
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsBooleanArray(boolean[])
     */
    public void setValuesAsBooleanArray(boolean[] value) {
        EList valueList = resetValues();

        for (int i = 0; i < value.length; i++) {
            valueList.add(String.valueOf(value[i]));
        }

        setType(TYPE_BOOLEAN_ARRAY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsBooleanArray()
     */
    public boolean[] getValuesAsBooleanArray() {
        if (getType().equals(TYPE_BOOLEAN_ARRAY)) {
            EList newValues = getValues();
            boolean[] booleanArray = new boolean[newValues.size()];

            for (int i = 0; i < newValues.size(); i++) {
                booleanArray[i] = (new Boolean((String) newValues.get(i))).booleanValue();
            }

            return booleanArray;
        }
        else {
            throw new IllegalStateException();
        }
    }

    /* (non-Javadoc)
         * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsByte(byte)
         */
    public void setValuesAsByte(byte value) {
        setValues(String.valueOf(value));
        setType(TYPE_BYTE);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsByte()
     */
    public byte getValuesAsByte() {
        if (getType().equals(TYPE_BYTE) && (getValues().size() == 1)) {
            return (new Byte((String) getValues().get(0))).byteValue();
        }
        else {
            throw new IllegalStateException();
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsByteArray(byte[])
     */
    public void setValuesAsByteArray(byte[] value) {
        EList valueList = resetValues();

        for (int i = 0; i < value.length; i++) {
            valueList.add(String.valueOf(value[i]));
        }

        setType(TYPE_BYTE_ARRAY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsByteArray()
     */
    public byte[] getValuesAsByteArray() {
        if (getType().equals(TYPE_BYTE_ARRAY)) {
            EList newValues = getValues();
            byte[] byteArray = new byte[newValues.size()];

            for (int i = 0; i < newValues.size(); i++) {
                byteArray[i] = (new Byte((String) newValues.get(i))).byteValue();
            }

            return byteArray;
        }
        else {
            throw new IllegalStateException();
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsDate(String)
     */
    public void setValuesAsDate(String value) {
        setValues(value);
        setType(TYPE_DATE_TIME);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsDate()
     */
    public String getValuesAsDate() {
        if (getType().equals(TYPE_DATE_TIME) && (getValues().size() != 0)) {
            return (String) getValues().get(0);
        }
        else {
            throw new IllegalStateException();
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsDateArray(String[])
     */
    public void setValuesAsDateArray(String[] value) {
        setValues(value);
        setType(TYPE_DATE_TIME_ARRAY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsDateArray()
     */
    public String[] getValuesAsDateArray() {
        if (getType().equals(TYPE_DATE_TIME_ARRAY)) {
            ArrayList valueArray = new ArrayList(getValues());
            String[] retArray = new String[valueArray.size()];

            return (String[]) valueArray.toArray(retArray);
        }
        else {
            throw new IllegalStateException();
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsDateAsLong(long)
     */
    public void setValuesAsDateAsLong(long value) {
        setValuesAsDate(EventHelpers.longToDate(value));
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsDateAsLong()
     */
    public long getValuesAsDateAsLong() {
        long result = 0;

        if (getType().equals(TYPE_DATE_TIME)) {
            if (getValues().size() != 0) {
                try {
                    result = EventHelpers.dateToLong(getValuesAsDate());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalStateException(getValuesAsDate() + " is not a valid xsd:dateTime"); /* NOI18N */
                }
            }
            else {
                throw new IllegalStateException("There are " + getValues().size() + " elements in the values array"); /* NOI18N */ /* NOI18N */
            }
        }
        else {
            throw new IllegalStateException("Invalid type " + getType()); /* NOI18N */
        }

        return result;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsDateAsLongArray(long[])
     */
    public void setValuesAsDateAsLongArray(long[] newValues) {
        String[] dateArray = new String[newValues.length];

        for (int i = 0; i < newValues.length; i++) {
            dateArray[i] = EventHelpers.longToDate(newValues[i]);
        }

        setValuesAsDateArray(dateArray);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsDateAsLongArray()
     */
    public long[] getValuesAsDateAsLongArray() {
        String[] dateArray = getValuesAsDateArray();
        long[] longArray = new long[dateArray.length];

        for (int i = 0; i < dateArray.length; i++) {
            try {
                longArray[i] = EventHelpers.dateToLong(dateArray[i]);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(dateArray[i] + " is not a valid xsd:dateTime value"); /* NOI18N */
            }
        }

        return longArray;
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsDouble(double)
     */
    public void setValuesAsDouble(double value) {
        setValues(String.valueOf(value));
        setType(TYPE_DOUBLE);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsDouble()
     */
    public double getValuesAsDouble() {
        if (getType().equals(TYPE_DOUBLE) && (getValues().size() == 1)) {
            return (new Double((String) getValues().get(0))).doubleValue();
        }
        else {
            throw new IllegalStateException();
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsDoubleArray(double[])
     */
    public void setValuesAsDoubleArray(double[] value) {
        EList valueList = resetValues();

        for (int i = 0; i < value.length; i++) {
            valueList.add(String.valueOf(value[i]));
        }

        setType(TYPE_DOUBLE_ARRAY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsDoubleArray()
     */
    public double[] getValuesAsDoubleArray() {
        if (getType().equals(TYPE_DOUBLE_ARRAY)) {
            EList localValues = getValues();
            double[] doubleArray = new double[localValues.size()];

            for (int i = 0; i < localValues.size(); i++) {
                doubleArray[i] = (new Double((String) localValues.get(i))).doubleValue();
            }

            return doubleArray;
        }
        else {
            throw new IllegalStateException();
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsFloat(float)
     */
    public void setValuesAsFloat(float value) {
        setValues(String.valueOf(value));
        setType(TYPE_FLOAT);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsFloat()
     */
    public float getValuesAsFloat() {
        if (getType().equals(TYPE_FLOAT) && (getValues().size() == 1)) {
            return (new Float((String) getValues().get(0))).floatValue();
        }
        else {
            throw new IllegalStateException();
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsFloatArray(float[])
     */
    public void setValuesAsFloatArray(float[] value) {
        EList valueList = resetValues();

        for (int i = 0; i < value.length; i++) {
            valueList.add(String.valueOf(value[i]));
        }

        setType(TYPE_FLOAT_ARRAY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsFloatArray()
     */
    public float[] getValuesAsFloatArray() {
        if (getType().equals(TYPE_FLOAT_ARRAY)) {
            EList localValues = getValues();
            float[] floatArray = new float[localValues.size()];

            for (int i = 0; i < localValues.size(); i++) {
                floatArray[i] = (new Float((String) localValues.get(i))).floatValue();
            }

            return floatArray;
        }
        else {
            throw new IllegalStateException();
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsInt(int)
     */
    public void setValuesAsInt(int value) {
        setValues(Integer.toString(value));
        setType(TYPE_INT);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsInt()
     */
    public int getValuesAsInt() {
        if (getType().equals(TYPE_INT) && (getValues().size() == 1)) {
            return Integer.parseInt((String) getValues().get(0));
        }
        else {
            throw new IllegalStateException();
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsIntArray(int[])
     */
    public void setValuesAsIntArray(int[] value) {
        EList valueList = resetValues();

        for (int i = 0; i < value.length; i++) {
            valueList.add(Integer.toString(value[i]));
        }

        setType(TYPE_INT_ARRAY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsIntArray()
     */
    public int[] getValuesAsIntArray() {
        if (getType().equals(TYPE_INT_ARRAY)) {
            EList localValues = getValues();
            int[] intArray = new int[localValues.size()];

            for (int i = 0; i < localValues.size(); i++) {
                intArray[i] = (new Integer((String) localValues.get(i))).intValue();
            }

            return intArray;
        }
        else {
            throw new IllegalStateException();
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsLong(long)
     */
    public void setValuesAsLong(long value) {
        setValues(String.valueOf(value));
        setType(TYPE_LONG);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsLong()
     */
    public long getValuesAsLong() {
        if (getType().equals(TYPE_LONG) && (getValues().size() == 1)) {
            return (new Long((String) getValues().get(0))).longValue();
        }
        else {
            throw new IllegalStateException();
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsLongArray(long[])
     */
    public void setValuesAsLongArray(long[] value) {
        EList valueList = resetValues();

        for (int i = 0; i < value.length; i++) {
            valueList.add(String.valueOf(value[i]));
        }

        setType(TYPE_LONG_ARRAY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsLongArray()
     */
    public long[] getValuesAsLongArray() {
        if (getType().equals(TYPE_LONG_ARRAY)) {
            EList localValues = getValues();
            long[] longArray = new long[localValues.size()];

            for (int i = 0; i < localValues.size(); i++) {
                longArray[i] = (new Long((String) localValues.get(i))).longValue();
            }

            return longArray;
        }
        else {
            throw new IllegalStateException();
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsShort(short)
     */
    public void setValuesAsShort(short value) {
        setValues(String.valueOf(value));
        setType(TYPE_SHORT);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsShort()
     */
    public short getValuesAsShort() {
        if (getType().equals(TYPE_SHORT) && (getValues().size() == 1)) {
            return (new Short((String) getValues().get(0))).shortValue();
        }
        else {
            throw new IllegalStateException();
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsShortArray(short[])
     */
    public void setValuesAsShortArray(short[] value) {
        EList valueList = resetValues();

        for (int i = 0; i < value.length; i++) {
            valueList.add(String.valueOf(value[i]));
        }

        setType(TYPE_SHORT_ARRAY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsShortArray()
     */
    public short[] getValuesAsShortArray() {
        if (getType().equals(TYPE_SHORT_ARRAY)) {
            EList localValues = getValues();
            short[] shortArray = new short[localValues.size()];

            for (int i = 0; i < localValues.size(); i++) {
                shortArray[i] = (new Short((String) localValues.get(i))).shortValue();
            }

            return shortArray;
        }
        else {
            throw new IllegalStateException();
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsString(java.lang.String)
     */
    public void setValuesAsString(String value) {
        setValues(value);
        setType(TYPE_STRING);
    }

    /* (non-Javadoc)
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsString()
     */
    public String getValuesAsString() {
        if (getType().equals(TYPE_STRING) && (getValues().size() == 1)) {
            return (String) getValues().get(0);
        }
        else {
            throw new IllegalStateException();
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setValuesAsStringArray(String[])
     */
    public void setValuesAsStringArray(String[] value) {
        setValues(value);
        setType(TYPE_STRING_ARRAY);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#getValuesAsStringArray()
     */
    public String[] getValuesAsStringArray() {
        if (getType().equals(TYPE_STRING_ARRAY)) {
            ArrayList valueArray = new ArrayList(getValues());
            String[] retArray = new String[valueArray.size()];

            return (String[]) valueArray.toArray(retArray);
        }
        else {
            throw new IllegalStateException();
        }
    }

    /**
     * Adds a new child <code>ExtendedDataElement</code> to this object.
     *
     * @param extendedDataElement the new child extended data element.
     * @return                    a reference to the child extended data element added to this object.
     * @see #getChildren()
     */
    public ExtendedDataElement addChild(ExtendedDataElement child) {

        getChildren().add(child);

        return child;
    }

    /**
     * Removes all child ExtenedDataElements that this event is referencing 
     */
    public void clearChildren() {
        getChildren().clear();
    }

    /**
     * Remove a named child extended data element that this event is referencing 
     * 
     * @param name the name of the child element to be removed
     */
    public void removeChildren(String name) {

        if (getChildren() != null) {

            for (int counter = 0; counter < getChildren().size(); counter++) {

                if (((ExtendedDataElement) (getChildren().get(counter))).getName().equals(name)) {
                    getChildren().remove(counter--);
                }
            }
        }
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChild(String)
     */
    public ExtendedDataElement addChild(String newName) {
        ExtendedDataElement ede = EventFactory.eINSTANCE.createExtendedDataElement();
        ede.setName(newName);
        getChildren().add(ede);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChild(String, int, String)
     */
    public ExtendedDataElement addChild(String newName, int newType, String value) {
        ExtendedDataElement ede = addChild(newName);
        ede.setTypeAsInt(newType);
        if (TYPE_HEX_BINARY_VALUE == newType) {
            ede.setHexValue(value);
        }
        else {
            ede.getValues().add(value);
        }

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChild(String, int, String[])
     */
    public ExtendedDataElement addChild(String newName, int newType, String[] newValues) {
        ExtendedDataElement ede = addChild(newName);
        ede.setTypeAsInt(newType);
        ede.getValues().addAll(Arrays.asList(newValues));

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChild(String, String)
     */
    public ExtendedDataElement addChild(String newName, String value) {
        return addChild(newName, TYPE_STRING_VALUE, value);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChild(String, String[])
     */
    public ExtendedDataElement addChild(String newName, String[] newValues) {
        return addChild(newName, TYPE_STRING_ARRAY_VALUE, newValues);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithByteArrayValue(String, byte[])
     */
    public ExtendedDataElement addChildWithBooleanArrayValue(String newName, boolean[] newValues) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsBooleanArray(newValues);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithByteValue(String, byte)
     */
    public ExtendedDataElement addChildWithBooleanValue(String newName, boolean value) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsBoolean(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithByteArrayValue(String, byte[])
     */
    public ExtendedDataElement addChildWithByteArrayValue(String newName, byte[] newValues) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsByteArray(newValues);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithByteValue(String, byte)
     */
    public ExtendedDataElement addChildWithByteValue(String newName, byte value) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsByte(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithDateArrayValue(String, String[])
     */
    public ExtendedDataElement addChildWithDateArrayValue(String newName, String[] newValues) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsDateArray(newValues);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithDateAsLongValue(String, long)
     */
    public ExtendedDataElement addChildWithDateAsLongValue(String newName, long value) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsDateAsLong(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithDateValue(String, String)
     */
    public ExtendedDataElement addChildWithDateValue(String newName, String value) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsDate(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithDatesAsLongValue(String, long[])
     */
    public ExtendedDataElement addChildWithDatesAsLongValue(String newName, long[] newValues) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsDateAsLongArray(newValues);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithDoubleArrayValue(String, double[])
     */
    public ExtendedDataElement addChildWithDoubleArrayValue(String newName, double[] newValues) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsDoubleArray(newValues);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithDoubleValue(String, double)
     */
    public ExtendedDataElement addChildWithDoubleValue(String newName, double value) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsDouble(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithFloatArrayValue(String, float[])
     */
    public ExtendedDataElement addChildWithFloatArrayValue(String newName, float[] newValues) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsFloatArray(newValues);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithFloatValue(String, float)
     */
    public ExtendedDataElement addChildWithFloatValue(String newName, float value) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsFloat(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChild(String, String)
     */
    public ExtendedDataElement addChildWithHexValue(String newName, String value) {
        ExtendedDataElement ede = addChild(newName);
        ede.setType(TYPE_HEX_BINARY);
        ede.setHexValue(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChild(String, String)
     */
    public ExtendedDataElement addChildWithHexValueAsByteArray(String newName, byte[] value) {
        ExtendedDataElement ede = addChild(newName);
        ede.setType(TYPE_HEX_BINARY);
        ede.setHexValueAsByteArray(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithIntArrayValue(String, int[])
     */
    public ExtendedDataElement addChildWithIntArrayValue(String newName, int[] newValues) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsIntArray(newValues);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithIntValue(String, int)
     */
    public ExtendedDataElement addChildWithIntValue(String newName, int value) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsInt(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithLongArrayValue(String, long[])
     */
    public ExtendedDataElement addChildWithLongArrayValue(String newName, long[] newValues) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsLongArray(newValues);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithLongValue(String, long)
     */
    public ExtendedDataElement addChildWithLongValue(String newName, long value) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsLong(value);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithShortArrayValue(String, short[])
     */
    public ExtendedDataElement addChildWithShortArrayValue(String newName, short[] newValues) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsShortArray(newValues);

        return ede;
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#addChildWithShortValue(String, short)
     */
    public ExtendedDataElement addChildWithShortValue(String newName, short value) {
        ExtendedDataElement ede = addChild(newName);
        ede.setValuesAsShort(value);

        return ede;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.EXTENDED_DATA_ELEMENT__HEX_VALUE :
                return getHexValue();
            case EventPackage.EXTENDED_DATA_ELEMENT__NAME :
                return getName();
            case EventPackage.EXTENDED_DATA_ELEMENT__TYPE :
                return getType();
            case EventPackage.EXTENDED_DATA_ELEMENT__VALUES :
                return getValues();
            case EventPackage.EXTENDED_DATA_ELEMENT__CHILDREN :
                return getChildren();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case EventPackage.EXTENDED_DATA_ELEMENT__CHILDREN :
                    return ((InternalEList) getChildren()).basicRemove(otherEnd, msgs);
                default :
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.EXTENDED_DATA_ELEMENT__HEX_VALUE :
                return HEX_VALUE_EDEFAULT == null ? hexValue != null : !HEX_VALUE_EDEFAULT.equals(hexValue);
            case EventPackage.EXTENDED_DATA_ELEMENT__NAME :
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case EventPackage.EXTENDED_DATA_ELEMENT__TYPE :
                return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
            case EventPackage.EXTENDED_DATA_ELEMENT__VALUES :
                return values != null && !values.isEmpty();
            case EventPackage.EXTENDED_DATA_ELEMENT__CHILDREN :
                return children != null && !children.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.EXTENDED_DATA_ELEMENT__HEX_VALUE :
                setHexValue((String) newValue);
                return;
            case EventPackage.EXTENDED_DATA_ELEMENT__NAME :
                setName((String) newValue);
                return;
            case EventPackage.EXTENDED_DATA_ELEMENT__TYPE :
                setType((String) newValue);
                return;
            case EventPackage.EXTENDED_DATA_ELEMENT__VALUES :
                getValues().clear();
                getValues().addAll((Collection) newValue);
                return;
            case EventPackage.EXTENDED_DATA_ELEMENT__CHILDREN :
                getChildren().clear();
                getChildren().addAll((Collection) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.EXTENDED_DATA_ELEMENT__HEX_VALUE :
                setHexValue(HEX_VALUE_EDEFAULT);
                return;
            case EventPackage.EXTENDED_DATA_ELEMENT__NAME :
                setName(NAME_EDEFAULT);
                return;
            case EventPackage.EXTENDED_DATA_ELEMENT__TYPE :
                setType(TYPE_EDEFAULT);
                return;
            case EventPackage.EXTENDED_DATA_ELEMENT__VALUES :
                getValues().clear();
                return;
            case EventPackage.EXTENDED_DATA_ELEMENT__CHILDREN :
                getChildren().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object arg0) {
        return EventHelpers.compareEObject(this, arg0);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (hexValue: ");
        result.append(hexValue);
        result.append(", name: ");
        result.append(name);
        result.append(", type: ");
        result.append(type);
        result.append(", values: ");
        result.append(values);
        result.append(", children: ");
        result.append(children);
        result.append(')');
        return result.toString();
    }
    /**
     * @see com.ibm.events.cbe.ExtendedDataElement#isValid(int)
     */
    public static boolean isValid(int type) {
        switch (type) {
            case TYPE_NO_VALUE_VALUE :
            case TYPE_BYTE_VALUE :
            case TYPE_SHORT_VALUE :
            case TYPE_INT_VALUE :
            case TYPE_LONG_VALUE :
            case TYPE_FLOAT_VALUE :
            case TYPE_DOUBLE_VALUE :
            case TYPE_STRING_VALUE :
            case TYPE_DATE_TIME_VALUE :
            case TYPE_BOOLEAN_VALUE :
            case TYPE_BYTE_ARRAY_VALUE :
            case TYPE_SHORT_ARRAY_VALUE :
            case TYPE_INT_ARRAY_VALUE :
            case TYPE_LONG_ARRAY_VALUE :
            case TYPE_FLOAT_ARRAY_VALUE :
            case TYPE_DOUBLE_ARRAY_VALUE :
            case TYPE_STRING_ARRAY_VALUE :
            case TYPE_DATE_TIME_ARRAY_VALUE :
            case TYPE_BOOLEAN_ARRAY_VALUE :
            case TYPE_HEX_BINARY_VALUE :
                return true;
            default :
                return false;
        }
    }
    /**
     * @see com.ibm.events.cbe.ExtendedDataElement#isValid(String)
     */
    public static boolean isValid(String type) {
        return EDE_TYPES_LIST.contains(type);
    }

    /**
     * @see com.ibm.events.cbe.ExtendedDataElement#typeToString(int)
     */
    public static String typeToString(int type) {
        try {
            return (String) EDE_TYPES_LIST.get(type);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    /**
     * @see com.ibm.events.cbe.ExtendedDataElement#typeToInt(String)
     */
    public static int typeToInt(String type) {
        return EDE_TYPES_LIST.indexOf(type);
    }

    /**
     * Checks whether the contents of this object conforms to the
     * CBE specification.
     *
     * @throws ValidationException
     *                       if the object does not follow the
     *                       CBE specification.
     */
    public void validate() throws ValidationException {

        EAttribute attr;
        EventPackage ePck = EventPackage.eINSTANCE;

        // checking for required attributes         
        EventValidation.validateRequiredProperties(CLASS_NAME, this);

        // checking that type is set to one of the supported strings
        String myType = getType();
        if (EDE_TYPES_LIST.contains(myType) == false) {
            Object[] params = new Object[] { getName(), getType()};
            EventValidation.throwValidationException(CLASS_NAME, EventMessages.LOG_EXTENDED_DATA_INVALID_TYPE_EXC_, params);
        }

        // We have already checked that "type" is one of the valid values, now check specific type:
        //   "noValue" means can't have "hexValue" or "value" attributes 
        //   "hexBinary" means "hexValue" attribute must be present
        //   otherwise, "value" attribute must be present
        if (getTypeAsInt() == TYPE_NO_VALUE_VALUE) {
            if ((getValues().size() > 0) || (getHexValue() != null)) {

                EAttribute attrT = ePck.getExtendedDataElement_Type();
                EAttribute attrV = ePck.getExtendedDataElement_Values();
                EAttribute attrH = ePck.getExtendedDataElement_HexValue();
                String[] myExcData = new String[] { EventValidation.getComponentName(this, attrV.getName()), EventValidation.getComponentName(this, attrH.getName())};
                EventValidation.throwValidationException(CLASS_NAME, EventMessages.LOG_INCONSISTENT_ATTRIBUTES_EXC_, new Object[] { EventValidation.getComponentName(this, attrT.getName()), getType(), Arrays.asList(myExcData)});
            }
        }
        else if (getTypeAsInt() == TYPE_HEX_BINARY_VALUE) {
            if (getHexValue() == null) {
                attr = ePck.getExtendedDataElement_HexValue();
                EventValidation.throwMissingPropertyException(CLASS_NAME, EventMessages.LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_, new Object[] { EventValidation.getComponentName(this, attr.getName()), getClass()});
            }
        }
        else {
            if (getValues().size() == 0) {
                attr = ePck.getExtendedDataElement_Values();
                EventValidation.throwMissingPropertyException(CLASS_NAME, EventMessages.LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_, new Object[] { EventValidation.getComponentName(this, attr.getName()), getClass()});
            }
        }

        // checking for mutually exclusive attributes (one, but not both, of these must be present)
        if ((getValues().size() > 0) && (getHexValue() != null)) {

            EAttribute attV = ePck.getExtendedDataElement_Values();
            EAttribute attH = ePck.getExtendedDataElement_HexValue();

            EventValidation.throwValidationException(CLASS_NAME, EventMessages.LOG_MUTUALLY_EXCLUSIVE_ATTRIBUTES_EXC_, new Object[] { EventValidation.getComponentName(this, attV.getName()), EventValidation.getComponentName(this, attH.getName()), });
        }

        EAttribute attN = ePck.getExtendedDataElement_Name();
        EAttribute attT = ePck.getExtendedDataElement_Type();

        // checking for boundaries
        EventValidation.validateLength(CLASS_NAME, this, attN, MAX_NAME_LENGTH);
        EventValidation.validateLength(CLASS_NAME, this, attT, MAX_TYPE_LENGTH);

        // No max length for HexValue
        // EventValidation.validateLength(this, attH, 1024);
        // checking for EList boundaries
        EAttribute attV = ePck.getExtendedDataElement_Values();
        validateEListAsStringLength(attV, MAX_VALUE_LENGTH);

        // Checking whether all values inside the values array are not null
        int typeValue = getTypeAsInt();
        switch (typeValue) {
            case TYPE_BOOLEAN_VALUE :
            case TYPE_BYTE_VALUE :
            case TYPE_DATE_TIME_VALUE :
            case TYPE_DOUBLE_VALUE :
            case TYPE_FLOAT_VALUE :
            case TYPE_INT_VALUE :
            case TYPE_LONG_VALUE :
            case TYPE_SHORT_VALUE :
            case TYPE_STRING_VALUE :
            case TYPE_BOOLEAN_ARRAY_VALUE :
            case TYPE_BYTE_ARRAY_VALUE :
            case TYPE_DATE_TIME_ARRAY_VALUE :
            case TYPE_DOUBLE_ARRAY_VALUE :
            case TYPE_FLOAT_ARRAY_VALUE :
            case TYPE_INT_ARRAY_VALUE :
            case TYPE_LONG_ARRAY_VALUE :
            case TYPE_SHORT_ARRAY_VALUE :
            case TYPE_STRING_ARRAY_VALUE :
                List localValues = getValues();
                if (localValues.size() != 0) {
                    for (int i = 0; i < localValues.size(); i++) {
                        if (localValues.get(i) == null) {
                            Object[] params = new Object[] { getName(), getType()};
                            EventValidation.throwValidationException(CLASS_NAME, EventMessages.LOG_EXTENDED_DATA_VALUE_NULL_EXC_, params);
                        }
                    } // for values
                }
                else {
                    attr = ePck.getExtendedDataElement_HexValue();
                    EventValidation.throwMissingPropertyException(CLASS_NAME, EventMessages.LOG_MISSING_REQUIRED_ATTRIBUTE_EXC_, new Object[] { EventValidation.getComponentName(this, attr.getName()), getClass()});
                } // if values not null
                break;
            default :
                // nothing to be done
        } // switch type

        // Checking whether extended data element with single valued data 
        // types have one, and only one, value inside the values array. 
        String singleValue = null; // storing it for later use
        switch (typeValue) {
            case TYPE_BOOLEAN_VALUE :
            case TYPE_BYTE_VALUE :
            case TYPE_DATE_TIME_VALUE :
            case TYPE_DOUBLE_VALUE :
            case TYPE_FLOAT_VALUE :
            case TYPE_INT_VALUE :
            case TYPE_LONG_VALUE :
            case TYPE_SHORT_VALUE :
            case TYPE_STRING_VALUE :
                if (getValues().size() == 1) {
                    singleValue = (String) getValues().get(0);
                }
                else {
                    Object[] params = new Object[] { new Integer(getValues().size()), getName(), getType()};
                    EventValidation.throwValidationException(CLASS_NAME, EventMessages.LOG_VALUE_ARRAY_SIZE_MISMATCH_EXC_, params);
                }
                break;

            default :
                // nothing to be done
        }

        // Checking whether there is a number format conversion problem.
        // Earlier, when the values array was checked for size, the 
        // 'singleValue' variable was set with the value of the only
        // value inside the 'values' array.
        try {
            switch (typeValue) {
                case TYPE_BYTE_VALUE :
                    Byte.parseByte(singleValue);
                    break;
                case TYPE_DOUBLE_VALUE :
                    Double.parseDouble(singleValue);
                    break;
                case TYPE_FLOAT_VALUE :
                    Float.parseFloat(singleValue);
                    break;
                case TYPE_INT_VALUE :
                    Integer.parseInt(singleValue);
                    break;
                case TYPE_LONG_VALUE :
                    Long.parseLong(singleValue);
                    break;
                case TYPE_SHORT_VALUE :
                    Short.parseShort(singleValue);
                    break;
                default :
                    // nothing to do
            } // switch type
        }
        catch (NumberFormatException e) {
            Object[] params = new Object[] { singleValue, getType(), getName()};
            EventValidation.throwValidationException(CLASS_NAME, EventMessages.LOG_INVALID_TYPE_CONVERSION_EXC_, params);
        } // try numeric value conversion

        // checking whether all numeric values inside multi-valued elements can be
        // converted to their numeric counter-parts.
        String lastValue = null; // to improve error messages
        try {
            switch (typeValue) {
                case TYPE_BYTE_ARRAY_VALUE :
                    for (int i = 0; i < values.size(); i++) {
                        lastValue = (String) values.get(i);
                        Byte.parseByte(lastValue);
                    }
                    break;
                case TYPE_DOUBLE_ARRAY_VALUE :
                    for (int i = 0; i < values.size(); i++) {
                        lastValue = (String) values.get(i);
                        Double.parseDouble(lastValue);
                    }
                    break;
                case TYPE_FLOAT_ARRAY_VALUE :
                    for (int i = 0; i < values.size(); i++) {
                        lastValue = (String) values.get(i);
                        Float.parseFloat(lastValue);
                    }
                    break;
                case TYPE_INT_ARRAY_VALUE :
                    for (int i = 0; i < values.size(); i++) {
                        lastValue = (String) values.get(i);
                        Integer.parseInt(lastValue);
                    }
                    break;
                case TYPE_LONG_ARRAY_VALUE :
                    for (int i = 0; i < values.size(); i++) {
                        lastValue = (String) values.get(i);
                        Long.parseLong(lastValue);
                    }
                    break;
                case TYPE_SHORT_ARRAY_VALUE :
                    for (int i = 0; i < values.size(); i++) {
                        lastValue = (String) values.get(i);
                        Short.parseShort(lastValue);
                    }
                    break;
                default :
                    // nothing to do
            } // switch type
        }
        catch (NumberFormatException e) {
            Object[] params = new Object[] { lastValue, getType(), getName()};
            EventValidation.throwValidationException(CLASS_NAME, EventMessages.LOG_INVALID_TYPE_CONVERSION_EXC_, params);
        } // try check numeric array 

        // Miscellaneous final checks and determination of whether this
        // is a well known type
        switch (typeValue) {
            case TYPE_NO_VALUE_VALUE :
            case TYPE_BYTE_VALUE :
            case TYPE_SHORT_VALUE :
            case TYPE_INT_VALUE :
            case TYPE_LONG_VALUE :
            case TYPE_FLOAT_VALUE :
            case TYPE_DOUBLE_VALUE :
                break;

            case TYPE_STRING_VALUE :
                //	the individual values are checked by: validateEListAsStringLength()
                break;

            case TYPE_DATE_TIME_VALUE :
                if (isXsdDateTime(singleValue) == false) {
                    Object[] params = new Object[] { getName(), getType(), singleValue };
                    EventValidation.throwValidationException(CLASS_NAME, EventMessages.LOG_EXTENDED_DATA_INVALID_DATE_EXC_, params);
                }
                break;

            case TYPE_BOOLEAN_VALUE :
                if (isXsdBoolean(singleValue) == false) {
                    Object[] params = new Object[] { getName(), getType(), singleValue };
                    EventValidation.throwValidationException(CLASS_NAME, EventMessages.LOG_EXTENDED_DATA_INVALID_BOOLEAN_EXC_, params);
                }
                break;

            case TYPE_BYTE_ARRAY_VALUE :
            case TYPE_SHORT_ARRAY_VALUE :
            case TYPE_INT_ARRAY_VALUE :
            case TYPE_LONG_ARRAY_VALUE :
            case TYPE_FLOAT_ARRAY_VALUE :
            case TYPE_DOUBLE_ARRAY_VALUE :
                break;

            case TYPE_STRING_ARRAY_VALUE :
                // the individual values are checked by: validateEListAsStringLength()
                break;

            case TYPE_DATE_TIME_ARRAY_VALUE :
                values = getValues();
                for (int i = 0; i < values.size(); i++) {
                    lastValue = (String) values.get(i);
                    if (isXsdDateTime(lastValue) == false) {
                        Object[] params = new Object[] { getName(), getType(), lastValue };
                        EventValidation.throwValidationException(CLASS_NAME, EventMessages.LOG_EXTENDED_DATA_INVALID_DATE_EXC_, params);
                    } // if bad date time
                }
                break;

            case TYPE_BOOLEAN_ARRAY_VALUE :
                values = getValues();

                for (int i = 0; i < values.size(); i++) {
                    String value = (String) values.get(i);
                    if (isXsdBoolean(value) == false) {
                        Object[] params = new Object[] { getName(), getType(), value };
                        EventValidation.throwValidationException(CLASS_NAME, EventMessages.LOG_EXTENDED_DATA_INVALID_BOOLEAN_EXC_, params);
                    }
                } // for values

                break;

            case TYPE_HEX_BINARY_VALUE :

                String myHexData = getHexValue();

                if (myHexData != null) {
                    validateHexBinary(myHexData);
                } // if hexBinary data

                break;

            default :
                // Should have been thrown before
        }

        // need to validate children attribute.  Note, children can have children
        EList localChildren = getChildren();
        ExtendedDataElement child;

        for (int i = 0; i < localChildren.size(); i++) {
            child = (ExtendedDataElement) localChildren.get(i);
            child.validate();
        }
    }

    /**
     * Sets the value of the extended data element as String value.
     *
     * @param value the new value for the extended data element
     */
    protected void setValues(String value) {
        EList valueList = resetValues();
        valueList.add(value);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getExtendedDataElement();
    }

    /**
     * Resets the value of the extended data element.
     * 
     * @deprecated Use clearValues();
     */
    protected EList resetValues() {
        clearValues();
        return getValues();
    }

    /**
     * Removes all values that this event is referencing 
     */
    public void clearValues() {
        getValues().clear();
    }

    /**
     * Required to circumvent a problem with de/serializing EMF ELists with RMI over IIOP by 
     * converting EMF ELists to Lists.  
     * 
     * @see java.io.Serializable
     */
    private void readObject(java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
        EventHelpers.serializableRead(this, in);
    }

    /*
     * Private methods.
     */

    /**
     * Determines whether a string is a valid XSD boolean string.
     *
     * @param value          string to be checked
     *
     * @return               <code>true</code> if the string is a valid
     *                       XSD boolean string.
     */
    private boolean isXsdBoolean(String value) {
        return (value.equals("true") || //$NON-NLS-1$
        value.equals("false") || //$NON-NLS-1$ 
        value.equals("1") || //$NON-NLS-1$
        value.equals("0")); //$NON-NLS-1$   
    }

    /**
     * Checks whether a CreationTime conforms to the spec
     */
    private boolean isXsdDateTime(String inDate) {
        boolean validDate = true;
        long milliseconds = 0;

        try {
            milliseconds = EventHelpers.dateToLong(inDate);
        }
        catch (IllegalArgumentException ex) {
            validDate = false;
        }

        return validDate;
    }

    /**
     * check whether each entry in a List of strings conforms to the max length
     */
    private void validateEListAsStringLength(EStructuralFeature att, int maxLength) throws ValidationException {
        EList list = (EList) eGet(att);
        if (list != null) {
            ListIterator it = list.listIterator();
            while (it.hasNext()) {
                String outstr = (String) it.next();
                int length = 0;
                if (outstr != null) {
                    length = outstr.length();
                    if (length > maxLength) {
                        Object[] params = new Object[] { outstr, EventValidation.getComponentName(this, att.getName()), new Integer(maxLength)};
                        EventValidation.throwValidationException(CLASS_NAME, EventMessages.LOG_INVALID_LIST_ELEMENT_LENGTH_EXC_, params);
                    }
                } // if non-null string
            } // while elements
        } // if list not null
    }

    /**
     * Required to circumvent a problem with de/serializing EMF ELists with RMI over IIOP by 
     * converting EMF ELists to Lists.  
     * 
     * @see java.io.Serializable
     */
    private void writeObject(java.io.ObjectOutputStream out) throws IOException {
        EventHelpers.serializableWrite(this, out);
    }

    /**
     * @see org.eclipse.hyades.logging.events.cbe.ExtendedDataElement#setHexValueAsByteArray(byte[])
     *         
     * Converts a byte array to a hexBinary string
     *
     * @param inByteArray A byte array
     *
     * @return String Conversion of the byte array to a hexBinary string.
     */
    private String byteArrayToHexBinary(byte[] inByteArray) {
        String result = null;

        if (inByteArray != null) {
            StringBuffer hexValueAsString = new StringBuffer(inByteArray.length * 2);
            for (int i = 0; i < inByteArray.length; i++) {
                hexValueAsString.append(HEX_BASE_CHARS[(inByteArray[i] & 0xF0) >> 4]);
                hexValueAsString.append(HEX_BASE_CHARS[inByteArray[i] & 0x0F]);
            }

            result = hexValueAsString.toString();
        }

        return result;
    }

    /**
     * Converts a <code>xsd:hexBinary</code> string to the corresponding
     * array of bytes. 
     * 
     * @param inHexData A String containing hexBinary data
     *
     * @return               conversion of the string to a byte array.  
     *                       If the input is <code>null</code>, a null byte 
     *                       array will be returned.
     * 
     * @throws IllegalStateException 
     *                       if the input is not an even length or if the
     *                       input does not contain hex characters
     */
    private byte[] hexBinaryToByteArray(String inHexData) throws IllegalStateException {
        byte[] result = null;

        if (inHexData != null) {
            int count = inHexData.length();
            if ((count % 2) == 1) {
                throw new IllegalArgumentException("inHexData must have an even length"); /* NOI18N */
            }
            result = new byte[count / 2];
            // The idea is to iterate over the bytes and come up with
            // the hexadecimal pair of characters that represent it.
            byte byteValue = 0;
            for (int i = 0; i < count; i = i + 2) {
                int resultIndex = i / 2;
                for (int j = 0; j < 2; j++) {
                    char c = inHexData.charAt(i + j);
                    switch (Character.toUpperCase(c)) {
                        case '0' :
                            byteValue = 0;
                            break;
                        case '1' :
                            byteValue = 1;
                            break;
                        case '2' :
                            byteValue = 2;
                            break;
                        case '3' :
                            byteValue = 3;
                            break;
                        case '4' :
                            byteValue = 4;
                            break;
                        case '5' :
                            byteValue = 5;
                            break;
                        case '6' :
                            byteValue = 6;
                            break;
                        case '7' :
                            byteValue = 7;
                            break;
                        case '8' :
                            byteValue = 8;
                            break;
                        case '9' :
                            byteValue = 9;
                            break;
                        case 'A' :
                            byteValue = 10;
                            break;
                        case 'B' :
                            byteValue = 11;
                            break;
                        case 'C' :
                            byteValue = 12;
                            break;
                        case 'D' :
                            byteValue = 13;
                            break;
                        case 'E' :
                            byteValue = 14;
                            break;
                        case 'F' :
                            byteValue = 15;
                            break;
                        default :
                            {
                                throw new IllegalStateException("string is not a valid hexBinary"); /* NOI18N */
                            }
                    } // switch hex character

                    if (j == 0) {
                        result[resultIndex] = (byte) (byteValue << 4);
                    }
                    else {
                        result[resultIndex] += byteValue;
                    }
                } // for 1st, 2nd byte
            } // for characters
        } // if inHexData not null

        return result;
    }

    /**
     * Determines whether an xsd:hexBinary string conforms to the 
     * specification.
     * 
     * @param hexString      value to be checked.
     * 
     * @throws ValidationException
     *                       if the string does not conform to the
     *                       specification
     */
    private void validateHexBinary(String hexString) throws ValidationException {
        // Must be an even number of characters
        if ((hexString.length() % 2) != 0) {
			Object[] params = new Object[] { getName(), getType(), hexString};
			EventValidation.throwValidationException(
				CLASS_NAME,
			EventMessages.LOG_EXTENDED_DATA_INVALID_HEX_BINARY_1_EXC_,
				params);
        }

        // Must be all hex characters
        for (int i = 0; i < hexString.length(); i++) {
            char c = hexString.charAt(i);
            c = Character.toUpperCase(c);
            boolean found = false;
            for (int j = 0; j < HEX_BASE_CHARS.length; j++) {
                if (c == HEX_BASE_CHARS[j]) {
                    found = true;
                    break;
                }
            } // for hex characters.
            if (found == false) {
				Object[] params = new Object[] { getName(), getType(), hexString, new Character(c)};
				EventValidation.throwValidationException(
					CLASS_NAME,
				EventMessages.LOG_EXTENDED_DATA_INVALID_HEX_BINARY_2_EXC_,
					params);
            }
        } // for characters
    }

    /**
     * return a cloned (copy by value) object. This is a deep copy version, in which all the
     * objects within this object will be copied by value.
     *  
     * @return Object
     */
    public Object clone() throws CloneNotSupportedException {
        return EcoreUtil.copy(this);
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {

        setHexValue(HEX_VALUE_EDEFAULT);
        setName(NAME_EDEFAULT);
        setType(TYPE_EDEFAULT);

        clearValues();
        clearChildren();
    }
} //ExtendedDataElementImpl
