package org.eclipse.hyades.logging.events.cbe.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.logging.events.cbe.EventPackage;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.ValidationException;
import org.eclipse.hyades.logging.events.cbe.util.EventHelpers;
import org.eclipse.hyades.logging.events.cbe.util.EventValidation;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Situation Type</b></em>'.
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1
 * @implements Cloneable
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.logging.events.cbe.impl.SituationTypeImpl#getReasoningScope <em>Reasoning Scope</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class SituationTypeImpl extends SerializableImpl implements SituationType, Cloneable {

    /** Automatically generated javadoc for: serialVersionUID */
    private static final long serialVersionUID = -8522169030887137276L;

    /**
     * Classname for trace/log 
     */
    private static final String CLASS_NAME = SituationTypeImpl.class.getName();

    /** Maximum length for the disposition fields in the situation. */
    protected static final int DISPOSITION_MAX_LENGTH = 64;

    /** Maximum length for the reasoning scope according to the CBE spec. */
    private static final int REASONING_SCOPE_MAX_LENGTH = 64;

    /**
     * The default value of the '{@link #getReasoningScope() <em>Reasoning Scope</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getReasoningScope()
     * @generated
     * @ordered
     */
    protected static final String REASONING_SCOPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getReasoningScope() <em>Reasoning Scope</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getReasoningScope()
     * @generated
     * @ordered
     */
    protected String reasoningScope = REASONING_SCOPE_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SituationTypeImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return EventPackage.eINSTANCE.getSituationType();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getReasoningScope() {
        return reasoningScope;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setReasoningScope(String newReasoningScope) {
        String oldReasoningScope = reasoningScope;
        reasoningScope = newReasoningScope;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, EventPackage.SITUATION_TYPE__REASONING_SCOPE, oldReasoningScope, reasoningScope));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.SITUATION_TYPE__REASONING_SCOPE :
                return getReasoningScope();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.SITUATION_TYPE__REASONING_SCOPE :
                setReasoningScope((String) newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.SITUATION_TYPE__REASONING_SCOPE :
                setReasoningScope(REASONING_SCOPE_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case EventPackage.SITUATION_TYPE__REASONING_SCOPE :
                return REASONING_SCOPE_EDEFAULT == null ? reasoningScope != null : !REASONING_SCOPE_EDEFAULT.equals(reasoningScope);
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy())
            return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (reasoningScope: ");
        result.append(reasoningScope);
        result.append(')');
        return result.toString();
    }

    /**
     * Checks whether the contents of the instance conform to the
     * CBE specification.
     *
     * @throws ValidationException 
     *                       if the event instance does not follow the 
     *                       CBE specification.
     */
    public void validate() throws ValidationException {
        // checking for presence of all attributes
        EventValidation.validateRequiredProperties(CLASS_NAME, this);

        // checking for boundaries
        EventPackage ePck = EventPackage.eINSTANCE;
        EAttribute attr = ePck.getSituationType_ReasoningScope();
        EventValidation.validateLength(CLASS_NAME, this, attr, REASONING_SCOPE_MAX_LENGTH);
    }

    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object arg0) {
        return EventHelpers.compareEObject(this, arg0);
    }

	/**
	 * return a cloned (copy by value) object. This is a deep copy version, in which all the
	 * objects within this object will be copied by value.
	 *  
	 * @return Object
	 */
	public Object clone() throws CloneNotSupportedException {
		return EcoreUtil.copy(this);
	}

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * All components are initialized to either zero or null.
     * 
     * @since 1.0
     */
    public void init() {
        setReasoningScope(REASONING_SCOPE_EDEFAULT);
    }
} //SituationTypeImpl
