package org.eclipse.hyades.logging.events.cbe.impl.tests;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.ConfigureSituation;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.SituationType;
import org.eclipse.hyades.logging.events.cbe.ValidationException;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * 
 * @author Denilson Nastacio
 * @version 1.0.1
 * @since 1.0.1 
 */
public class ConfigureSituationImplTest extends TestCase {

    /** Target instance for the tests. */
    private ConfigureSituation sit;

    /**
     * Constructor for ConfigureSituationImplTest.
     * @param arg0
     */
    public ConfigureSituationImplTest(String arg0) {
        super(arg0);
    }

    /**
     * Tests whether <code>toString</code> doesn't blow up.
     */
    public void testToString() {
        assertNotNull(sit.toString());
    }

    /**
     * Tests presence of attributes in the public interface
     */
    public void testInterface() {
        sit.getSuccessDisposition();
        sit.getReasoningScope();
        // setters show on other tests

        assertTrue(sit instanceof SituationType);
    }

    /**
     * Tests the serialization for <code>AvailableSituation</code>.
     */
    public void testSerialization() {
        Util.testEObjectSerialization(sit);
    }

    /**
     * Tests the <code>equals</code> operator.
     */
    public void testEquals() {
        ConfigureSituation sit2 = (ConfigureSituation) Util.clone(sit);
        assertEquals(sit, sit2);

        sit.setSuccessDisposition("s");
        sit.setReasoningScope("r");
        sit2 = (ConfigureSituation) Util.clone(sit);
        assertEquals(sit, sit2);

        sit.setSuccessDisposition("difference");
        assertFalse(sit.equals(sit2));
    }

    /**
     * Tests validation for <code>AvailableSituation</code>.
     */
    public void testValidationMissingAttributes() throws ValidationException {
        Util.assertMissingAttributes(sit, "all");

        sit.setSuccessDisposition("s");
        sit.setReasoningScope("r");
        sit.validate();

        sit.setSuccessDisposition(null);
        Util.assertMissingAttributes(sit, "successDisposition");

        sit.setSuccessDisposition("s");
        sit.setReasoningScope(null);
        Util.assertMissingAttributes(sit, "reasoningScope");
    }

    /**
     * Tests validation for <code>AvailableSituation</code>.
     */
    public void testValidationInvalidLengths() {
        sit.setSuccessDisposition(Util.getPaddedString(64));
        sit.setReasoningScope(Util.getPaddedString(64));
        try {
            sit.validate();
        }
        catch (ValidationException e) {
            fail("Strings have correct length");
        }

        sit.setSuccessDisposition(Util.getPaddedString(65));
        sit.setReasoningScope(Util.getPaddedString(64));
        Util.assertInvalidBoundaries(sit, "successDisposition");

        sit.setSuccessDisposition(Util.getPaddedString(64));
        sit.setReasoningScope(Util.getPaddedString(65));
        Util.assertInvalidBoundaries(sit, "reasoningScope");
    }

    /**
     * 
     */
    public void testAdapter() {
        Util.assertAdapterNotification(sit);
    }

    /**
     * 
     */
    public void testUnsupportedFeature() {
        Util.assertUnsupportedFeature(sit);
    }

    /*
     * Protected methods.
     */

    /* (non-Javadoc)
     * @see junit.framework.TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        EventFactory eFx = EventFactory.eINSTANCE;
        sit = eFx.createConfigureSituation();

    }

}
