package org.eclipse.hyades.logging.events.cbe.impl.tests;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

import junit.framework.TestCase;

import org.eclipse.hyades.logging.events.cbe.AssociatedEvent;
import org.eclipse.hyades.logging.events.cbe.AssociationEngine;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.ContextDataElement;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.ExtendedDataElement;
import org.eclipse.hyades.logging.events.cbe.MsgCatalogToken;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;

/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * Tests whether EMF produce the CBEs correctly.
 * 
 * @author Denilson Nastacio
 * @author Scott Brown
 * @version 1.0.1
 * @since 1.0.1
 */
public class EventPackageImplTest extends TestCase {

    /**
     * Target instance for all fixtures 
     */
    private EventFactory cfi;

    /**
     * Constructor for CbeFactoryImplTest.
     * @param testcase
     */
    public EventPackageImplTest(String testcase) {
        super(testcase);
    }

    /**
     * Tests whether the <code>AssociationEngine</code> was generated 
     * correctly.
     */
    public void testCreateAssociationEngine() throws Exception {
        AssociationEngine aet = cfi.createAssociationEngine();

        aet.setId("A");
        aet.setName("A");
        aet.setType("A");

        assertTrue(aet.getId() instanceof String);
        assertTrue(aet.getName() instanceof String);
        assertTrue(aet.getType() instanceof String);

        testSerialization(aet);
    }

    /**
     * Tests whether the <code>ComponentIdentification</code> was generated 
     * correctly.
     */
    public void testCreateComponentIdentification() throws Exception {
        ComponentIdentification cit = cfi.createComponentIdentification();

        // checking whether setters and getters have the proper s 		
        cit.setApplication("A");
        cit.setComponent("A");
        cit.setComponentIdType("A");
        cit.setExecutionEnvironment("A");
        cit.setInstanceId("A");
        cit.setLocation("A");
        cit.setLocationType("A");
        cit.setProcessId("A");
        cit.setSubComponent("A");
        cit.setThreadId("A");

        assertTrue(cit.getApplication() instanceof String);
        assertTrue(cit.getComponent() instanceof String);
        assertTrue(cit.getComponentIdType() instanceof String);
        assertTrue(cit.getExecutionEnvironment() instanceof String);
        assertTrue(cit.getInstanceId() instanceof String);
        assertTrue(cit.getLocation() instanceof String);
        assertTrue(cit.getLocationType() instanceof String);
        assertTrue(cit.getProcessId() instanceof String);
        assertTrue(cit.getSubComponent() instanceof String);
        assertTrue(cit.getThreadId() instanceof String);

        testSerialization(cit);
    }

    /**
     * Tests whether the <code>ContextDataElement</code> was generated 
     * correctly.
     */
    public void testCreateContextDataElement() throws Exception {
        ContextDataElement cdet = cfi.createContextDataElement();

        ContextDataElement cdet1 = cfi.createContextDataElement();
        cdet.setContextId("A");
        cdet.setContextValue("A");
        cdet.setName("A");
        cdet.setType("A");

        assertTrue(cdet.getContextId() instanceof String);
        assertTrue(cdet.getContextValue() instanceof String);
        assertTrue(cdet.getName() instanceof String);
        assertTrue(cdet.getType() instanceof String);

        testSerialization(cdet);
    }

    /**
     * Tests whether the <code>ExtendedDataElement</code> was generated 
     * correctly.
     */
    public void testCreateExtendedDataElement() throws Exception {
        ExtendedDataElement edet = cfi.createExtendedDataElement();

        ExtendedDataElement edet1 = cfi.createExtendedDataElement();
        edet.getChildren().add(edet1);
        edet.getValues().add("A");
        edet.setHexValue("A");
        edet.setName("A");
        edet.setType("A");

        assertTrue(edet.getChildren().get(0) instanceof ExtendedDataElement);
        assertTrue(edet.getValues().get(0) instanceof String);
        assertTrue(edet.getHexValue() instanceof String);
        assertTrue(edet.getName() instanceof String);
        assertTrue(edet.getType() instanceof String);

        testSerialization(edet);
    }

    /**
     * Tests whether the <code>AssociatedEvent</code> was generated 
     * correctly.
     */
    public void testCreateAssociatedEvent() throws Exception {
        AssociatedEvent aet = cfi.createAssociatedEvent();

        AssociationEngine ae = cfi.createAssociationEngine();
        aet.setAssociationEngine("A");
        aet.setResolvedEvents("A");

        assertTrue(aet.getAssociationEngine() instanceof String);
        assertTrue(aet.getResolvedEvents() instanceof String);

        testSerialization(aet);
    }

    /**
     * Tests whether the <code>MsgDataElement</code> was generated 
     * correctly.
     */
    public void testCreateMsgDataElement() throws Exception {
        MsgDataElement mdet = cfi.createMsgDataElement();

        // checking whether setters and getters have the proper s
        mdet.setMsgCatalog("A");
        mdet.setMsgCatalogId("A");
        mdet.setMsgId("A");
        mdet.setMsgLocale("A");
        MsgCatalogToken mct = cfi.createMsgCatalogToken();
        mdet.getMsgCatalogTokens().add(mct);

        assertTrue(mdet.getMsgCatalog() instanceof String);
        assertTrue(mdet.getMsgCatalogId() instanceof String);
        assertTrue(mdet.getMsgId() instanceof String);
        assertTrue(mdet.getMsgLocale() instanceof String);
        assertTrue(mdet.getMsgCatalogTokens().get(0) instanceof MsgCatalogToken);

        testSerialization(mdet);
    }

    /**
     * Tests whether the <code>CommonBaseEvent</code> has been 
     * properly generated. 
     */
    public void testCreateCommonBaseEvent() throws Exception {
        CommonBaseEvent cbe = cfi.createCommonBaseEvent();

        cbe.setCreationTime("1999-05-31T13:20:00-05:00");
        cbe.setGlobalInstanceId("Id01234567890123");
        ComponentIdentification cit = cfi.createComponentIdentification();
        cbe.setReporterComponentId(cit);
        cit = cfi.createComponentIdentification();
        cbe.setSourceComponentId(cit);

        assertTrue(cbe.getCreationTime() instanceof String);
        assertTrue(cbe.getGlobalInstanceId() instanceof String);
        assertTrue(cbe.getReporterComponentId() instanceof ComponentIdentification);
        assertTrue(cbe.getSourceComponentId() instanceof ComponentIdentification);

        testSerialization(cbe);
    }

    /**
     * Tests the limits 
     */

    /*
     * Protected methods
     */

    /**
     * 
     */
    protected void setUp() {
        cfi = EventFactory.eINSTANCE;
    }

    /**
     * 
     */
    protected void tearDown() throws Exception {
    }

    /*
     * Private methods
     */

    /**
     * Tests whether the object passed as parameter can be serialized and
     * deserialized.
     * 
     * @param o              object to be tested
     * 
     * @throws IOException
     */
    private void testSerialization(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bos);
        oo.writeObject(o);
    }

}
