/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.test.http.internal.launch;

import java.util.List;

import org.eclipse.hyades.test.http.launch.tabs.LoadTestUserTab;
import org.eclipse.hyades.test.ui.launch.tabGroups.BasicTestTabGroup;

/**
 * @author jnevicos
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class HttpTestTabGroup extends BasicTestTabGroup {
	
	/**
	 * Add to the tab list any additional tab.
	 * This method should be sub-classed to provide additional tabs. These tabs
	 * are inserted before the Profiling tab (if any) or the Common tab.
	 * @param tabList
	 */
	protected void addAdditionalTabs(List tabList, String mode) {
		LoadTestUserTab foo = new LoadTestUserTab();
		tabList.add(new LoadTestUserTab());
	}
	
	/**
	 * Add to the tab list the Hyades Test Selection Tab.
	 * @param tabList
	 */
	protected void addRunnableItemSelectionTab(List tabList, String mode) {
		addTestAndDeploymentTab(tabList, mode, HttpTestLaunchConfigurationFacade.LAUNCH_CONFIGURATION_TYPE);
	}
}
