/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.http.internal.reports.responsetime;

import org.eclipse.hyades.models.common.testprofile.TPFExecutionResult;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFTypedEvent;
import org.eclipse.hyades.test.http.internal.reports.HttpAbstractReport;

/**
 * @author amathur
 * @author jnevicos
 * 
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ResponseTimeReport extends HttpAbstractReport
{

	/**
	 * 
	 */
	public ResponseTimeReport(TPFExecutionResult result) {
		super(result);
	}

	/**
	 * Adds Overall Average data 
	 */
	protected void finishReport() 
	{
		if (list.size() > 1) //don't add overall if less than 2 elements
		{		
			list.add(new ResponseTimeData.OverallResponseTime());
		}		
	}
	
	protected void setupReport()
	{
		ResponseTimeData.resetCumulativeValues();
	}
	
	protected void processMessageEvent(TPFMessageEvent event)
	{
		String message = event.getText();
		int responseTimeIndex = message.indexOf(responseTimeMarker); 
		if(responseTimeIndex!=-1)
		{
			String pageName = message.substring(message.indexOf(pageNameMarker)+pageNameMarker.length(),responseTimeIndex).trim();
			String responseTime = message.substring(responseTimeIndex+responseTimeMarker.length(),message.length());
			responseTime=responseTime.substring(0,responseTime.indexOf(lf)).trim();
					
			System.out.println(pageName+":"+responseTime); 
			ResponseTimeData data = (ResponseTimeData)findPage(pageName);
			if(data==null)
			{
				data = new ResponseTimeData(pageName);
				list.add(data);
			}
			data.addSample(new Long(responseTime).longValue());										
		}
		
	}
	
	protected void processTypedEvent(TPFTypedEvent typedEvent) {} 

}
