package org.eclipse.hyades.execution.security;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

public interface IClientHandler {
	
	public byte[] getRemoteAddress();

	/**
	 *  Read bytes from client on secure socket
	 */	
	public int read(byte[] b, int off, int len);
	
	/**
	 *  Write bytes to client on secure socket
	 */
	public int write(byte[] b, int off, int len);
	
	/**
	 *  Close the connection to the client
	 */
	public void closeConnection();
}