/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * Insert the type's description here.
 * Creation date: (11/2/00 7:49:38 PM)
 * @author:
 */
public class SetNVPairCommand extends SimpleAgentInfoCommand {

	protected RAString _type=new RAString("");
	protected RAString _name=new RAString("");
	protected RAString _value=new RAString("");
/**
 * SetNVPairCommand constructor comment.
 */
public SetNVPairCommand() {
	super();
	_tag=RA_SET_NAME_VALUE_PAIR;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/00 7:52:45 PM)
 * @return java.lang.String
 */
public String getName() {
	return _name.getData();
}
/**
 * getSize method comment.
 */
public int getSize() {
	int size=super.getSize();
	size+=_type.getSize();
	size+=_name.getSize();
	size+=_value.getSize();
	return size;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/00 7:53:15 PM)
 * @return java.lang.String
 */
public String getType() {
	return _type.getData();
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/00 7:53:42 PM)
 * @return java.lang.String
 */
public String getValue() {
	return _value.getData();
}
/**
 * readFromBuffer method comment.
 */
public int readFromBuffer(byte[] buffer, int offset) {
	int current=super.readFromBuffer(buffer, offset);
	current=Message.writeRAStringToBuffer(buffer, current, _type);
	current=Message.writeRAStringToBuffer(buffer, current, _name);
	current=Message.writeRAStringToBuffer(buffer, current, _value);
	return current;
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/00 7:55:20 PM)
 * @param name java.lang.String
 */
public void setName(String name) {
	_name.setData(name);
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/00 7:54:59 PM)
 * @param type java.lang.String
 */
public void setType(String type) {
	_type.setData(type);
}
/**
 * Insert the method's description here.
 * Creation date: (11/2/00 7:55:53 PM)
 * @param value java.lang.String
 */
public void setValue(String value) {
	_value.setData(value);
}
/**
 * writeToBuffer method comment.
 */
public int writeToBuffer(byte[] buffer, int offset) {
	int current=super.writeToBuffer(buffer, offset);
	current=Message.writeRAStringToBuffer(buffer, current, _type);
	current=Message.writeRAStringToBuffer(buffer, current, _name);
	current=Message.writeRAStringToBuffer(buffer, current, _value);
	return current;
}
}
