/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.control;

public interface ProcessListener {
	
	/**
	 * Invoked when a process is launched.  The
	 * process parameter contains all the information
	 * regarding the process.
	 */
	void processLaunched(Process process);
	
	
	/**
	 * Invoked when a process that was previously launched
	 * exits.The process parameter contains all the information
	 * regarding the process.
	 */
	void processExited(Process process);

}

