/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.security;

/**
 * @author rduggan
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */

import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;
import org.eclipse.hyades.internal.execution.local.control.Application;

public class UserFactory {

	private static Hashtable _table=new Hashtable();

	/**
	 * Create a user for a specific application so that we can have multiple
	 * connections open to a Node.
	 */
	public static synchronized User  createUser(Application app, String name, String password) throws DuplicateUserException{
		Vector userList=(Vector)_table.get(app.getName());
		
		if(userList==null) {
			userList=new Vector();
			_table.put(app.getName(), userList);
		}
		else {
			Enumeration e=userList.elements();
			while(e.hasMoreElements()) {
				User user=(User)e.nextElement();	
				if(user.getName().equals(name)) {
					throw new DuplicateUserException();
				}
			}
			
		}
		
		User user=new User(app, name, password);
		userList.add(user);
		
		return user;
	}
	
	public static synchronized void removeAllUsers(Application app) {
		_table.remove(app.getName());
		
	}
	
	public static User removeUser(Application app, String name) {
		Vector userList=(Vector)_table.get(app.getName());
		if(userList!=null) {
			Object[] users=userList.toArray();
			for(int i=0; i<users.length; i++) {
				User currentUser=(User)users[i];
				if(currentUser.getName().equals(name)) {
					userList.remove(i);
					return currentUser;
				}
			}
		}
		return null;
	}
	
	/**
	 * Retrieve a user for a specific application.
	 */
	public static synchronized User getUser(Application app, String name) {
		User user=null;
		Vector userList=(Vector)_table.get(app.getName());
		if(userList!=null) {
			Enumeration e=userList.elements();
			while(e.hasMoreElements()) {
				user=(User)e.nextElement();	
				if(user.getName().equals(name)) {
					return user;
				}
			}
		}
		return null;
	}
}
