/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.edit.datapool;

/**
 * Default implementation of the {@link IDatapoolListener} class.  Available for 
 * use as a base class for listener classes so that all methods do not need to be
 * implemented. 
 */
public class DatapoolAdapter implements IDatapoolListener
{
	
	public void variableAdded(IDatapool datapool, int newVariableIndex)
	{
	}
	
	public void variableRemoved(IDatapool datapool, int variableIndex)
	{
	}
	
	public void variableMoved(IDatapool datapool, int sourceVariableIndex, int targetVariableIndex)
	{
	}
	
	public void variableChanged(IDatapool datapool, int variableIndex)
	{
	}
	
	public void variableChanged(IDatapool datapool, int variableIndex, String oldName)
	{
	}
	
	public void recordAdded(IDatapool datapool, int EquivClassIndex, int newRecordIndex)
	{
	}
	
	public void recordRemoved(IDatapool datapool, int EquivClassIndex, int recordIndex)
	{
	}
	
	public void recordMoved(IDatapool datapool, int EquivClassIndex, int sourceRecordIndex, int targetRecordIndex)
	{
	}

	public void recordChanged(IDatapool datapool, int EquivClassIndex, int recordIndex)
	{
	}
	
	public void cellChanged(IDatapool datapool, int equivalenceClassIndex, int recordIndex, int variableIndex)
	{
	}
	
	public void equivalenceClassReordered(IDatapool datapool, int equivalenceClassIndex)
	{
	}
	
	public void equivalenceClassAdded(IDatapool datapool, int newEquivalenceClassIndex)
	{
	}
		
	public void equivalenceClassRemoved(IDatapool datapool, int equivalenceClassIndex)
	{
	}
	
	public void equivalenceClassMoved(IDatapool datapool, int sourceEquivalenceClassIndex, int targetEquivalenceClassIndex)
	{	
	}
	
	public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex)
	{
	}	

	public void equivalenceClassChanged(IDatapool datapool, int equivalenceClassIndex, String oldName)
	{
	}
	
	public void save(IDatapool datapool)
	{
	}
}
