/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.edit.datapool;

/**
 * A logical grouping of values in a {@link IDatapool datapool}.  A datapool
 * is an ordered collection {@link IDatapoolEquivalenceClass equivalence classes}
 * which contain an order collection of records.  And to complete the 
 * hierarchy, a record is an ordered collection of {@link IDatapoolCell cells}.
 * <p>
 * Several restrictions exist on records within a datapool:
 * <ul>
 * <li>A record instance can only exist in one datapool.  Obviously a deep
 * copy can be performed so the same contents can appear in multiple datapools.</li>
 * <li>A record instance must be unique within the datapool.  It can not
 * be added to multiple equivalence classes or more then once to the
 * same equivalence class.</li>
 * <li>Cells within a record must each be unique to that instance of the
 * record and can not be duplicated in multiple records at once.
 * <li>Cells within a record can only be added to the record once and can
 * not be inserted into the same record multiple times.</li>
 * </ul>
 */
public interface IDatapoolRecord extends 
	org.eclipse.hyades.execution.runtime.datapool.IDatapoolRecord
{
		
	/**
	 * Replace a value at the specified zero based cell index.
	 * 
	 * @param	cell		The value to replace in the specified cell.
	 * @param	cellIndex	A zero based cell index.
	 * 
	 * @see #getCell(int)
	 */
	public void setCell(IDatapoolCell cell, int cellIndex);
	
}
