/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCTraceObject;
import org.eclipse.hyades.uml2sd.trace.TraceSDPlugin;

/**
 * This is the concrete class for object interaction loader
 */
public class ObjectInteractions extends TraceInteractions {

	/**
	 * The lifeline to be used for this message is the owning object
	 */
	protected EObject getLifelineEObjectFromMethodInvocation(TRCFullMethodInvocation mi) {
		if (mi.getOwningObject().getIsA() == mi.getProcess().getClassClass())
			return mi.getMethod().getDefiningClass(); // TRCClass
		return mi.getOwningObject(); // TRCTraceObject
	}

	/**
	 * The name of the lifeline is the name of the class,
	 * prefixed with the id of the owning object if any
	 */
	protected String getLifeLineTitle(EObject eo, boolean long_) {
		TRCClass cl;
		String owningObject = ""; //$NON-NLS-1$
		if (eo instanceof TRCTraceObject) {
			TRCTraceObject to = (TRCTraceObject)eo;
			cl = ((TRCTraceObject)eo).getIsA();
			owningObject = ":" + to.getId(); //$NON-NLS-1$
		} else {
			cl = (TRCClass)eo;
		}
		return cl.getName() + owningObject +
			   (!long_ && cl.getPackage() != null ? (" ("+cl.getPackage().getName()+")") : ""); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}

	/**
	 * The category of such a lifeline is:
	 * - the Classes category if and only if the name of the class of the owning object is "class";
	 *   that means that the method is static usually
	 * - the Object category in any other situation
	 */
	protected int getLifeLineCategory(EObject eo) {
		if (eo instanceof TRCClass) {
			return TraceInteractions.CATEGORY_CLASSES;
		}
		return TraceInteractions.CATEGORY_OBJECTS;
	}
	
	/**
	 * This is the object interactions, nothing else
	 */
	public String getFinalTitleString() {
		return TraceSDPlugin.getResourceString("STR_UML2SD_OBJECT_INTERACTION"); //$NON-NLS-1$
	}
	
}
