/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.trace.loaders.internal;

import java.util.Iterator;

import org.eclipse.hyades.models.trace.TRCFullMethodInvocation;
import org.eclipse.hyades.models.trace.TRCProcess;


/**
 * A way to iterate on method invocations of a TRCProcess 
 */
public class TraceProcess {
	
	private TRCProcess process;
	private Iterator iterator;
	private double startTime, currentRelativeTime;
	private TRCFullMethodInvocation methodInvocation;
	
	/**
	 * @param process_
	 */
	public TraceProcess(TRCProcess process_) {
		process = process_;
	}
	
	/**
	 * 
	 */
	public void init() {
		iterator = process.getInvocations().iterator();
		startTime = TraceInteractionUtils.getAbsoluteEntryTime(process);
		nextInvocation(); // pump up for the first one (this first call to nextInvocation returns null)

	}

	/**
	 * @return
	 */
	public TRCProcess getProcess() {
		return process;
	}
	
	public boolean hasNext() {
		return methodInvocation != null;
	}
	
	/**
	 * @return
	 */
	public double getCurrentTime() {
		return TraceInteractionUtils.getAbsoluteEntryTime(process.getAgent()) + currentRelativeTime;
	}
	
	/**
	 * @return
	 */
	public double getStartTime() {
		return startTime;
	}
	
	/**
	 * @return
	 */
	public TRCFullMethodInvocation nextInvocation() {
		TRCFullMethodInvocation previous = methodInvocation;
		if (iterator.hasNext()) {
			methodInvocation = (TRCFullMethodInvocation)iterator.next();
			currentRelativeTime = methodInvocation.getEntryTime();
		} else {
			methodInvocation = null;
			currentRelativeTime = process.getLastEventTime();
		}
		return previous; // on first call it's null
	}
}
