package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * @author rduggan
 *
 * Taken from "Canonical Situation Data Format: The Common Base Event V1.0.1 
 * ACAB.BO0301.0.1"
 * 
 * The ContextDataElement type defines the context(s) that this event is referencing.
 * This complex type holds data that is used to assist with correlating messages or 
 * events generated along the execution path of a unit of work for problem diagnostic 
 * purposes.
 * 
 * @version 1.0
 * @deprecated This class is deprecated as of 2004-05-17. Use the corresponding class available in org.eclipse.hyades.logging.events.cbe*
 */
public interface IContextDataElement {

    /**
     * Returns the contextId.
     * 
     * This property is the reference to the element that contains the context.  This is
     * not required if contextValue specifies a value
     * 
     * @return String
     */
    public String getContextId();

    /**
     * Returns the contextValue.
     * 
     * The value of the context with respect to the implementation of the context.
     * This is not required if contextId specifies a value.
     * 
     * @return String
     */
    public String getContextValue();

    /**
     * Returns the name.
     * 
     * Name of the application that created this context data element. This is a 
     * REQUIRED property.
     * 
     * @return String
     */
    public String getName();

    /**
     * Returns the type.
     * 
     * The data type of the contextValue property. This is a REQUIRED property.
     * 
     * @return String
     */
    public String getType();

    /**
     * Sets the contextId.
     * 
     * This property is the reference to the element that contains the context.  This is
     * not required if contextValue specifies a value
     * 
     * @param contextId The contextId to set
     */
    public void setContextId(String contextId);

    /**
     * Sets the contextValue.
     * 
     * The value of the context with respect to the implementation of the context.
     * This is not required if contextId specifies a value.
     * 
     * @param contextValue The contextValue to set
     */
    public void setContextValue(String contextValue);

    /**
     * Sets the name.
     * 
     * Name of the application that created this context data element. This is a 
     * REQUIRED property.
     * 
     * @param name The name to set
     */
    public void setName(String name);

    /**
     * Sets the type.
     * 
     * The data type of the contextValue property. This is a REQUIRED property.
     * 
     * @param type The type to set
     */
    public void setType(String type);

	/**
	 * Resets the object's properties to their initial (e.g. null) state.
	 * 
	 * @since 1.0.1
	 */
	public void init();
}
