/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import org.eclipse.core.runtime.IConfigurationElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author slavescu
 */
public class HyadesConfigurationElement {
	//~ Instance fields ----------------------------------------------------------------------------

	private Object element;

	//~ Constructors -------------------------------------------------------------------------------

	public HyadesConfigurationElement(Object element) {
		this.element = element;
	}

	//~ Methods ------------------------------------------------------------------------------------

	public String getAttribute(String name) {
		if (RegistryReader.isPlatformMode()) {
			return ((IConfigurationElement) element).getAttribute(name);
		} else {
			return getFirstRealChild().getAttributes().getNamedItem(name).getNodeValue();
		}
	}

	private Node getFirstRealChild() {
		Node node = ((Node) element).getFirstChild();
		while(node != null && node.getAttributes()==null)
		{
			node = node.getNextSibling();
		}
		return node;
	}

	public HyadesConfigurationElement[] getChildren() {
		HyadesConfigurationElement[] hyadesConfigurationElements = new HyadesConfigurationElement[0];

		if (RegistryReader.isPlatformMode()) { // platform mode

			IConfigurationElement[] elements = ((IConfigurationElement) element).getChildren();

			if (elements.length > 0) {
				hyadesConfigurationElements = new HyadesConfigurationElement[elements.length];

				for (int i = 0; i < hyadesConfigurationElements.length; i++) {
					hyadesConfigurationElements[i] = new HyadesConfigurationElement(elements[i]);
				}
			}
		} else //standalone mode
		 {
			NodeList nodeList = ((Node) element).getFirstChild().getChildNodes();

			if (nodeList.getLength() > 0) {
				hyadesConfigurationElements = new HyadesConfigurationElement[nodeList.getLength()];

				for (int i = 0; i < hyadesConfigurationElements.length; i++) {
					hyadesConfigurationElements[i] = new HyadesConfigurationElement(nodeList.item(i));
				}
			}
		}

		return hyadesConfigurationElements;
	}

	/**
	 * @return
	 */
	public String getDeclaringExtensionName() {
		if (RegistryReader.isPlatformMode()) {
			return ((IConfigurationElement) element).getDeclaringExtension().getExtensionPointUniqueIdentifier();
		} else {
			return ((Node) element).getAttributes().getNamedItem("point").getNodeValue();
		}
	}

	/**
	 * @param object
	 */
	public void setElement(Object object) {
		element = object;
	}

	/**
	 * @return
	 */
	public Object getElement() {
		return element;
	}

	public String getName() {
		if (RegistryReader.isPlatformMode()) {
			return ((IConfigurationElement) element).getName();
		} else {
			return getFirstRealChild().getNodeName();
		}
	}
}
