/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.plugin.HierarchyPlugin;
import org.eclipse.hyades.models.hierarchy.util.IHyadesResourceExtension;
/**
 * @author slavescu
 */
public class HyadesResourceExtensions extends HashMap {
	private static HyadesResourceExtensions instance;
	private IHyadesResourceExtension defaultHyadesResourceFactory;
	private Properties defaultProperties = new Properties();
	public static HyadesResourceExtensions getInstance() {
		if (instance == null) {
			instance = new HyadesResourceExtensions();
			new HyadesResourceRegistryReader().readRegistry();
			try {
				Preferences preferences = HierarchyPlugin.getPlugin().getPluginPreferences();
				for (Iterator iter = instance.entrySet().iterator(); iter.hasNext();) {
					Map.Entry element = (Map.Entry) iter.next();
					IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension) element.getValue();
					if (instance.defaultHyadesResourceFactory == null && preferences.getString(IHyadesResourceExtension.LARGE_RESOURCE_SUPPORT_CURRENT_DB_TYPE).equals(hyadesResourceFactory.getStoreType((String) element.getKey()))) {
						String defaultStoreTypeName = preferences.getString(IHyadesResourceExtension.LARGE_RESOURCE_SUPPORT_CURRENT_DB_TYPE);
						instance.defaultHyadesResourceFactory = hyadesResourceFactory;
						instance.defaultProperties.setProperty("location", preferences.getString(defaultStoreTypeName+"/"+IHyadesResourceExtension.LRSP_LOCATION));
						instance.defaultProperties.setProperty("user", preferences.getString(defaultStoreTypeName+"/"+IHyadesResourceExtension.LRSP_USERNAME));
						instance.defaultProperties.setProperty("password", LoadersUtils.restorePassword(preferences.getString(defaultStoreTypeName+"/"+IHyadesResourceExtension.LRSP_PASSWORD)));
						instance.defaultProperties.setProperty("cacheSize", preferences.getString(defaultStoreTypeName+"/"+IHyadesResourceExtension.LRSP_CACHE_SIZE));
					}
				}
			} catch (Exception e) {
				// TODO: MS add support for standalone mode
			}
		}
		return instance;
	}
	public Resource createResource(URI uri) {
		IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension) getInstance().get(LoadersUtils.getPostfix(uri));
		if (hyadesResourceExtension == null)
			return null;
		return hyadesResourceExtension.createResource(uri, defaultProperties);
	}
	public EList createList(Class dataClass, InternalEObject owner, int featureID, int inverseFeatureID) {
		IHyadesResourceExtension hyadesResourceFactory = getHyadesResourceFactory(owner);
		if (hyadesResourceFactory == null)
			return null;
		return hyadesResourceFactory.createPagingList(dataClass, owner, featureID, inverseFeatureID);
	}
	public EList createList(Class dataClass, InternalEObject owner, int featureID) {
		IHyadesResourceExtension hyadesResourceFactory = getHyadesResourceFactory(owner);
		if (hyadesResourceFactory == null)
			return null;
		return hyadesResourceFactory.createPagingList(dataClass, owner, featureID);
	}
	public EList createList(InternalEObject owner, EStructuralFeature feature) {
		IHyadesResourceExtension hyadesResourceFactory = getHyadesResourceFactory(owner);
		if (hyadesResourceFactory == null)
			return null;
		return hyadesResourceFactory.createPagingList(owner, feature);
	}
	/**
	 * @param owner
	 * @return
	 */
	private IHyadesResourceExtension getHyadesResourceFactory(InternalEObject owner) {
		Resource resource = owner.eResource();
		if (resource == null) {
			if (defaultHyadesResourceFactory != null) {
				return defaultHyadesResourceFactory;
			}
			return null;
		}
		URI uri = resource.getURI();
		if (uri == null)
			return null;
		IHyadesResourceExtension hyadesResourceFactory = (IHyadesResourceExtension) getInstance().get(LoadersUtils.getPostfix(uri));
		return hyadesResourceFactory;
	}
	/**
	 * @param uri
	 * @param notLoaded
	 * @return
	 */
	public Resource createResource(URI uri, Collection notLoaded) {
		IHyadesResourceExtension hyadesResourceExtension = (IHyadesResourceExtension) getInstance().get(LoadersUtils.getPostfix(uri));
		if (hyadesResourceExtension == null)
			return null;
		return hyadesResourceExtension.createResource(uri, defaultProperties, notLoaded);
	}
	/**
	 * @return Returns the properties.
	 */
	public Properties getProperties() {
		return defaultProperties;
	}
}
/**
 * A plugin extension reader that populates the loaders registry. Clients are
 * not expected to use this class directly.
 */
class HyadesResourceRegistryReader extends RegistryReader {
	//~ Static fields/initializers
	// -----------------------------------------------------------------
	static final String TAG_RESOURCE_EXTENSION = "hyadesResourceExtension";
	static final String ATT_CLASS = "class";
	//~ Constructors
	// -------------------------------------------------------------------------------
	public HyadesResourceRegistryReader() {
		super(RegistryReader.HYADES_RESOURCE_EXTENSION_PPID);
	}
	//~ Methods
	// ------------------------------------------------------------------------------------
	protected boolean readElement(HyadesConfigurationElement element) {
		if (element.getName().equals(TAG_RESOURCE_EXTENSION)) {
			//			String filePostfix = element.getAttribute(ATT_FILE_POSTFIX);
			//			if (filePostfix == null) {
			//				logMissingAttribute(element, ATT_FILE_POSTFIX);
			//			}else
			if (element.getAttribute(ATT_CLASS) == null) {
				logMissingAttribute(element, ATT_CLASS);
			} else {
				try {
					IHyadesPluginClassDescriptor classDescriptor = createPluginClassDescriptor(element, ATT_CLASS);
					IHyadesResourceExtension f = (IHyadesResourceExtension) classDescriptor.createInstance();
					List postfixes = f.getSupportedPostfixes();
					for (Iterator iter = postfixes.iterator(); iter.hasNext();) {
						String postfix = (String) iter.next();
						if (HyadesResourceExtensions.getInstance().containsKey(postfix)) {
							logError(element, "A Hyades resource factory extension for these \"" + postfixes + "\" already exists, this extension will be ignored.");
						} else {
							HyadesResourceExtensions.getInstance().put(postfix, f);
						}
					}
				} catch (Exception e) {
					logError(element, e.getLocalizedMessage());
				}
				return true;
			}
		}
		return false;
	}
}