/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.util;

import java.util.Set;


/**
 * @author slavescu
 */
public interface LookupService {
    //~ Methods ------------------------------------------------------------------------------------

    Set getSupportedTypes();

    boolean deregister(HierarchyContext context, Class type, Object key);

    boolean deregister(HierarchyContext context, Object value);

	boolean deregister(HierarchyContext context, Class type);

	boolean deregister(HierarchyContext context);

    Object locate(HierarchyContext context, Object key);

    Object locate(HierarchyContext context, Class type, Object key);

    boolean register(HierarchyContext context, Object value);
}
