/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCExecParameter;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Process Proxy</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl#getRuntimeId <em>Runtime Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl#getPid <em>Pid</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl#getClasspath <em>Classpath</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl#getParameters <em>Parameters</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl#getLaunchMode <em>Launch Mode</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl#getVmArguments <em>Vm Arguments</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl#isActive <em>Active</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl#getExecParameters <em>Exec Parameters</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl#getEnvironmentVariables <em>Environment Variables</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl#getNode <em>Node</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl#getAgentProxies <em>Agent Proxies</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCProcessProxyImpl extends EObjectImpl  implements TRCProcessProxy {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getRuntimeId() <em>Runtime Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuntimeId()
	 * @generated
	 * @ordered
	 */
	protected static final String RUNTIME_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRuntimeId() <em>Runtime Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuntimeId()
	 * @generated
	 * @ordered
	 */
	protected String runtimeId = RUNTIME_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getPid() <em>Pid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPid()
	 * @generated
	 * @ordered
	 */
	protected static final int PID_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getPid() <em>Pid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPid()
	 * @generated
	 * @ordered
	 */
	protected int pid = PID_EDEFAULT;

	/**
	 * The default value of the '{@link #getClasspath() <em>Classpath</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClasspath()
	 * @generated
	 * @ordered
	 */
	protected static final String CLASSPATH_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getClasspath() <em>Classpath</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClasspath()
	 * @generated
	 * @ordered
	 */
	protected String classpath = CLASSPATH_EDEFAULT;

	/**
	 * The default value of the '{@link #getParameters() <em>Parameters</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParameters()
	 * @generated
	 * @ordered
	 */
	protected static final String PARAMETERS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getParameters() <em>Parameters</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParameters()
	 * @generated
	 * @ordered
	 */
	protected String parameters = PARAMETERS_EDEFAULT;

	/**
	 * The default value of the '{@link #getLaunchMode() <em>Launch Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLaunchMode()
	 * @generated
	 * @ordered
	 */
	protected static final int LAUNCH_MODE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLaunchMode() <em>Launch Mode</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLaunchMode()
	 * @generated
	 * @ordered
	 */
	protected int launchMode = LAUNCH_MODE_EDEFAULT;

	/**
	 * The default value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected static final String LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLocation() <em>Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected String location = LOCATION_EDEFAULT;

	/**
	 * The default value of the '{@link #getVmArguments() <em>Vm Arguments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVmArguments()
	 * @generated
	 * @ordered
	 */
	protected static final String VM_ARGUMENTS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVmArguments() <em>Vm Arguments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVmArguments()
	 * @generated
	 * @ordered
	 */
	protected String vmArguments = VM_ARGUMENTS_EDEFAULT;

	/**
	 * The default value of the '{@link #isActive() <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isActive()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ACTIVE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isActive() <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isActive()
	 * @generated
	 * @ordered
	 */
	protected boolean active = ACTIVE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getExecParameters() <em>Exec Parameters</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getExecParameters()
	 * @generated
	 * @ordered
	 */
	protected EList execParameters = null;

	/**
	 * The cached value of the '{@link #getEnvironmentVariables() <em>Environment Variables</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEnvironmentVariables()
	 * @generated
	 * @ordered
	 */
	protected EList environmentVariables = null;

	/**
	 * The cached value of the '{@link #getNode() <em>Node</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNode()
	 * @generated
	 * @ordered
	 */
	protected TRCNode node = null;

	/**
	 * The cached value of the '{@link #getAgentProxies() <em>Agent Proxies</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAgentProxies()
	 * @generated
	 * @ordered
	 */
	protected EList agentProxies = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCProcessProxyImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return HierarchyPackage.eINSTANCE.getTRCProcessProxy();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_PROCESS_PROXY__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getRuntimeId() {
		return runtimeId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRuntimeId(String newRuntimeId) {
		String oldRuntimeId = runtimeId;
		runtimeId = newRuntimeId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_PROCESS_PROXY__RUNTIME_ID, oldRuntimeId, runtimeId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getPid() {
		return pid;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPid(int newPid) {
		int oldPid = pid;
		pid = newPid;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_PROCESS_PROXY__PID, oldPid, pid));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getClasspath() {
		return classpath;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setClasspath(String newClasspath) {
		String oldClasspath = classpath;
		classpath = newClasspath;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_PROCESS_PROXY__CLASSPATH, oldClasspath, classpath));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getParameters() {
		return parameters;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParameters(String newParameters) {
		String oldParameters = parameters;
		parameters = newParameters;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_PROCESS_PROXY__PARAMETERS, oldParameters, parameters));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getLaunchMode() {
		return launchMode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLaunchMode(int newLaunchMode) {
		int oldLaunchMode = launchMode;
		launchMode = newLaunchMode;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_PROCESS_PROXY__LAUNCH_MODE, oldLaunchMode, launchMode));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLocation() {
		return location;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLocation(String newLocation) {
		String oldLocation = location;
		location = newLocation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_PROCESS_PROXY__LOCATION, oldLocation, location));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getVmArguments() {
		return vmArguments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVmArguments(String newVmArguments) {
		String oldVmArguments = vmArguments;
		vmArguments = newVmArguments;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_PROCESS_PROXY__VM_ARGUMENTS, oldVmArguments, vmArguments));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isActive() {
		return active;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setActive(boolean newActive) {
		boolean oldActive = active;
		active = newActive;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_PROCESS_PROXY__ACTIVE, oldActive, active));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getExecParameters() {
		if (execParameters == null) {
			execParameters = new EObjectContainmentWithInverseEList(TRCExecParameter.class, this, HierarchyPackage.TRC_PROCESS_PROXY__EXEC_PARAMETERS, HierarchyPackage.TRC_EXEC_PARAMETER__PROCESS_PROXY);
		}
		return execParameters;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getEnvironmentVariables() {
		if (environmentVariables == null) {
			environmentVariables = new EObjectContainmentWithInverseEList(TRCEnvironmentVariable.class, this, HierarchyPackage.TRC_PROCESS_PROXY__ENVIRONMENT_VARIABLES, HierarchyPackage.TRC_ENVIRONMENT_VARIABLE__PROCESS_PROXY);
		}
		return environmentVariables;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCNode getNode() {
		if (node != null && node.eIsProxy()) {
			TRCNode oldNode = node;
			node = (TRCNode)eResolveProxy((InternalEObject)node);
			if (node != oldNode) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, HierarchyPackage.TRC_PROCESS_PROXY__NODE, oldNode, node));
			}
		}
		return node;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCNode basicGetNode() {
		return node;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetNode(TRCNode newNode, NotificationChain msgs) {
		TRCNode oldNode = node;
		node = newNode;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_PROCESS_PROXY__NODE, oldNode, newNode);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNode(TRCNode newNode) {
		if (newNode != node) {
			NotificationChain msgs = null;
			if (node != null)
				msgs = ((InternalEObject)node).eInverseRemove(this, HierarchyPackage.TRC_NODE__PROCESS_PROXIES, TRCNode.class, msgs);
			if (newNode != null)
				msgs = ((InternalEObject)newNode).eInverseAdd(this, HierarchyPackage.TRC_NODE__PROCESS_PROXIES, TRCNode.class, msgs);
			msgs = basicSetNode(newNode, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, HierarchyPackage.TRC_PROCESS_PROXY__NODE, newNode, newNode));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getAgentProxies() {
		if (agentProxies == null) {
			agentProxies = new EObjectContainmentWithInverseEList(TRCAgentProxy.class, this, HierarchyPackage.TRC_PROCESS_PROXY__AGENT_PROXIES, HierarchyPackage.TRC_AGENT_PROXY__PROCESS_PROXY);
		}
		return agentProxies;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.TRC_PROCESS_PROXY__EXEC_PARAMETERS:
					return ((InternalEList)getExecParameters()).basicAdd(otherEnd, msgs);
				case HierarchyPackage.TRC_PROCESS_PROXY__ENVIRONMENT_VARIABLES:
					return ((InternalEList)getEnvironmentVariables()).basicAdd(otherEnd, msgs);
				case HierarchyPackage.TRC_PROCESS_PROXY__NODE:
					if (node != null)
						msgs = ((InternalEObject)node).eInverseRemove(this, HierarchyPackage.TRC_NODE__PROCESS_PROXIES, TRCNode.class, msgs);
					return basicSetNode((TRCNode)otherEnd, msgs);
				case HierarchyPackage.TRC_PROCESS_PROXY__AGENT_PROXIES:
					return ((InternalEList)getAgentProxies()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case HierarchyPackage.TRC_PROCESS_PROXY__EXEC_PARAMETERS:
					return ((InternalEList)getExecParameters()).basicRemove(otherEnd, msgs);
				case HierarchyPackage.TRC_PROCESS_PROXY__ENVIRONMENT_VARIABLES:
					return ((InternalEList)getEnvironmentVariables()).basicRemove(otherEnd, msgs);
				case HierarchyPackage.TRC_PROCESS_PROXY__NODE:
					return basicSetNode(null, msgs);
				case HierarchyPackage.TRC_PROCESS_PROXY__AGENT_PROXIES:
					return ((InternalEList)getAgentProxies()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_PROCESS_PROXY__NAME:
				return getName();
			case HierarchyPackage.TRC_PROCESS_PROXY__RUNTIME_ID:
				return getRuntimeId();
			case HierarchyPackage.TRC_PROCESS_PROXY__PID:
				return new Integer(getPid());
			case HierarchyPackage.TRC_PROCESS_PROXY__CLASSPATH:
				return getClasspath();
			case HierarchyPackage.TRC_PROCESS_PROXY__PARAMETERS:
				return getParameters();
			case HierarchyPackage.TRC_PROCESS_PROXY__LAUNCH_MODE:
				return new Integer(getLaunchMode());
			case HierarchyPackage.TRC_PROCESS_PROXY__LOCATION:
				return getLocation();
			case HierarchyPackage.TRC_PROCESS_PROXY__VM_ARGUMENTS:
				return getVmArguments();
			case HierarchyPackage.TRC_PROCESS_PROXY__ACTIVE:
				return isActive() ? Boolean.TRUE : Boolean.FALSE;
			case HierarchyPackage.TRC_PROCESS_PROXY__EXEC_PARAMETERS:
				return getExecParameters();
			case HierarchyPackage.TRC_PROCESS_PROXY__ENVIRONMENT_VARIABLES:
				return getEnvironmentVariables();
			case HierarchyPackage.TRC_PROCESS_PROXY__NODE:
				if (resolve) return getNode();
				return basicGetNode();
			case HierarchyPackage.TRC_PROCESS_PROXY__AGENT_PROXIES:
				return getAgentProxies();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_PROCESS_PROXY__NAME:
				setName((String)newValue);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__RUNTIME_ID:
				setRuntimeId((String)newValue);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__PID:
				setPid(((Integer)newValue).intValue());
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__CLASSPATH:
				setClasspath((String)newValue);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__PARAMETERS:
				setParameters((String)newValue);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__LAUNCH_MODE:
				setLaunchMode(((Integer)newValue).intValue());
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__LOCATION:
				setLocation((String)newValue);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__VM_ARGUMENTS:
				setVmArguments((String)newValue);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__ACTIVE:
				setActive(((Boolean)newValue).booleanValue());
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__EXEC_PARAMETERS:
				getExecParameters().clear();
				getExecParameters().addAll((Collection)newValue);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__ENVIRONMENT_VARIABLES:
				getEnvironmentVariables().clear();
				getEnvironmentVariables().addAll((Collection)newValue);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__NODE:
				setNode((TRCNode)newValue);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__AGENT_PROXIES:
				getAgentProxies().clear();
				getAgentProxies().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_PROCESS_PROXY__NAME:
				setName(NAME_EDEFAULT);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__RUNTIME_ID:
				setRuntimeId(RUNTIME_ID_EDEFAULT);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__PID:
				setPid(PID_EDEFAULT);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__CLASSPATH:
				setClasspath(CLASSPATH_EDEFAULT);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__PARAMETERS:
				setParameters(PARAMETERS_EDEFAULT);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__LAUNCH_MODE:
				setLaunchMode(LAUNCH_MODE_EDEFAULT);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__LOCATION:
				setLocation(LOCATION_EDEFAULT);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__VM_ARGUMENTS:
				setVmArguments(VM_ARGUMENTS_EDEFAULT);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__ACTIVE:
				setActive(ACTIVE_EDEFAULT);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__EXEC_PARAMETERS:
				getExecParameters().clear();
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__ENVIRONMENT_VARIABLES:
				getEnvironmentVariables().clear();
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__NODE:
				setNode((TRCNode)null);
				return;
			case HierarchyPackage.TRC_PROCESS_PROXY__AGENT_PROXIES:
				getAgentProxies().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case HierarchyPackage.TRC_PROCESS_PROXY__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case HierarchyPackage.TRC_PROCESS_PROXY__RUNTIME_ID:
				return RUNTIME_ID_EDEFAULT == null ? runtimeId != null : !RUNTIME_ID_EDEFAULT.equals(runtimeId);
			case HierarchyPackage.TRC_PROCESS_PROXY__PID:
				return pid != PID_EDEFAULT;
			case HierarchyPackage.TRC_PROCESS_PROXY__CLASSPATH:
				return CLASSPATH_EDEFAULT == null ? classpath != null : !CLASSPATH_EDEFAULT.equals(classpath);
			case HierarchyPackage.TRC_PROCESS_PROXY__PARAMETERS:
				return PARAMETERS_EDEFAULT == null ? parameters != null : !PARAMETERS_EDEFAULT.equals(parameters);
			case HierarchyPackage.TRC_PROCESS_PROXY__LAUNCH_MODE:
				return launchMode != LAUNCH_MODE_EDEFAULT;
			case HierarchyPackage.TRC_PROCESS_PROXY__LOCATION:
				return LOCATION_EDEFAULT == null ? location != null : !LOCATION_EDEFAULT.equals(location);
			case HierarchyPackage.TRC_PROCESS_PROXY__VM_ARGUMENTS:
				return VM_ARGUMENTS_EDEFAULT == null ? vmArguments != null : !VM_ARGUMENTS_EDEFAULT.equals(vmArguments);
			case HierarchyPackage.TRC_PROCESS_PROXY__ACTIVE:
				return active != ACTIVE_EDEFAULT;
			case HierarchyPackage.TRC_PROCESS_PROXY__EXEC_PARAMETERS:
				return execParameters != null && !execParameters.isEmpty();
			case HierarchyPackage.TRC_PROCESS_PROXY__ENVIRONMENT_VARIABLES:
				return environmentVariables != null && !environmentVariables.isEmpty();
			case HierarchyPackage.TRC_PROCESS_PROXY__NODE:
				return node != null;
			case HierarchyPackage.TRC_PROCESS_PROXY__AGENT_PROXIES:
				return agentProxies != null && !agentProxies.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", runtimeId: ");
		result.append(runtimeId);
		result.append(", pid: ");
		result.append(pid);
		result.append(", classpath: ");
		result.append(classpath);
		result.append(", parameters: ");
		result.append(parameters);
		result.append(", launchMode: ");
		result.append(launchMode);
		result.append(", location: ");
		result.append(location);
		result.append(", vmArguments: ");
		result.append(vmArguments);
		result.append(", active: ");
		result.append(active);
		result.append(')');
		return result.toString();
	}

} //TRCProcessProxyImpl
