/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.variableloader.internal;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.model.statistical.*;

import org.eclipse.emf.common.util.*;

import org.eclipse.swt.graphics.Image;

/**
 * This variable representation will make all the necessary modifications to the 
 * variable in the statistical model and then proxy the modifications to the
 * VariableModifierRepresentation passed in in the constructor
 */
public class SDModifiableVariable extends SDGenericVariable implements SDModifiableVariableRepresentation {
	
public static final int NONE = -1;
public static final int INTEGER = 0;
public static final int LONG = 1;
public static final int FLOAT = 2;
public static final int DOUBLE = 3;
public static final int STRING = 4;

Object value = null;

int measured_type = NONE;
int modifier_type = NONE;

StatisticalFactory factory = StatisticalFactory.eINSTANCE;

SDMemberDescriptor descriptor;
SDVariableModifierProxy modifier;

SDCounterDescriptor measured_desc;
SDCounterDescriptor requested_desc;
SDSnapshotObservation measured;
SDSnapshotObservation requested;

double min_bound = Double.MIN_VALUE;
double max_bound = Double.MAX_VALUE;

Object last_requested;
long last_req_time;
Object last_measured;
long last_mes_time;

	public int getMeasuredType() {
		return measured_type;	
	}

	public int getModifierType() {
		return modifier_type;	
	}

String[] possibles;
	public String[] getEnumerationValues() {
		return possibles;
	}
	public void setEnumerationValues(String[] possible) {
		possibles = possible;
	}

	SDModifiableVariable(String unique_id, String name, String description, Image image, boolean has_bar, int measured_type, int modifier_type, SDMemberDescriptor descriptor, SDVariableModifierProxy modifier, double min, double max, SDSampleWindow window) {
		super(unique_id,name,description,image,has_bar);
		
		this.measured_type = measured_type;
		this.modifier_type = modifier_type;
		this.descriptor = descriptor;
		this.modifier = modifier;
		
		this.min_bound = min;
		this.max_bound = max;
		
		if (measured_type == STRING) {
			measured = factory.createSDTextObservation();
			last_measured = null;
		} else {
			measured = factory.createSDContiguousObservation();
			last_measured = null;
		}
		measured.setWindow(window);

		if (modifier_type == STRING) {
			requested = factory.createSDTextObservation();
			last_requested = null;
		} else {
			requested = factory.createSDContiguousObservation();
			last_requested = new Double(0);
		}
		requested.setWindow(window);
		
		requested_desc = factory.createSDCounterDescriptor();
		requested_desc.setParent(descriptor);
		requested_desc.setName(name+" - "+EditorPlugin.getString("REQUESTED"));
		requested_desc.setDescription(description);
		
		measured_desc = factory.createSDCounterDescriptor();
		measured_desc.setParent(descriptor);
		measured_desc.setName(name+" - "+EditorPlugin.getString("MEASURED"));
		measured_desc.setDescription(description);

		requested_desc.setRepresentation(this);
		
		requested.setMemberDescriptor(requested_desc);
		measured.setMemberDescriptor(measured_desc);
		
	}
	
	public Object getLastMeasuredValue() {
		return last_measured;	
	}

	public long getLastMeasuredTime() {
		return last_mes_time;	
	}

	public Object getLastRequestedValue() {
		return last_requested;	
	}

	public long getLastRequestedTime() {
		return last_req_time;	
	}
	
	public double getMaxBound() {
		return max_bound;
	}
	public double getMinBound() {
		return min_bound;
	}
	
	private void addRequestedValue(long t, Double d) throws ClassCastException  {
		SDContiguousObservation obs = (SDContiguousObservation)requested;		
		BasicEList times = (BasicEList)obs.getCreationTime();
		BasicEList values = (BasicEList)obs.getValue();
		
		if (modifier_type == INTEGER) {
			d = new Double(d.intValue());	
		} else if (modifier_type == LONG) {
			d = new Double(d.longValue());	
		} else if (modifier_type == FLOAT) {
			d = new Double(d.floatValue());	
		}
		
		last_requested = d;
		last_req_time = t;
		addValue(times,values, t, d);
	}

	private void addRequestedValue(long t, String s) throws ClassCastException {
		SDTextObservation obs = (SDTextObservation)requested;		

		BasicEList times = (BasicEList)obs.getCreationTime();
		BasicEList values = (BasicEList)obs.getTextValue();
		
		addValue(times,values, t, s);

		last_requested = s;
		last_req_time = t;

	}

	private void addMeasuredValue(long t, Double d) throws ClassCastException  {
		SDContiguousObservation obs = (SDContiguousObservation)measured;		

		BasicEList times = (BasicEList)obs.getCreationTime();
		BasicEList values = (BasicEList)obs.getValue();

		if (measured_type == INTEGER) {
			d = new Double(d.intValue());	
		} else if (measured_type == LONG) {
			d = new Double(d.longValue());	
		} else if (measured_type == FLOAT) {
			d = new Double(d.floatValue());	
		}

		addValue(times,values, t, d);

		last_measured = d;
		last_mes_time = t;
	}
	
	private void addMeasuredValue(long t, String s) throws ClassCastException  {
		SDTextObservation obs = (SDTextObservation)measured;		

		BasicEList times = (BasicEList)obs.getCreationTime();
		BasicEList values = (BasicEList)obs.getTextValue();

		addValue(times,values, t, s);

		last_measured = s;
		last_mes_time = t;
	}
	
	public void padRequestedValue(long t) throws ClassCastException {
		if (last_requested != null) {
			if (last_requested instanceof Double) {
				addRequestedValue(t,(Double)last_requested);
			} else {
				addRequestedValue(t,(String)last_requested);
			}
		}
	}

	public void padRequestedValue(long t, Object val) throws ClassCastException {
		if (val != null) {
			if (val instanceof Number) {
				addRequestedValue(t,new Double(  ((Number)last_requested).doubleValue() ));
			} else {
				addRequestedValue(t,(String)val);
			}
		}
	}
	
	public void setRequestedValue(long t, int i) throws ClassCastException {
		addRequestedValue(t,new Double(i));
		modifier.requestValue(uid,i);
	}
	public void setRequestedValue(long t, long i) throws ClassCastException {
		addRequestedValue(t,new Double(i));
		modifier.requestValue(uid,i);
	}
	public void setRequestedValue(long t, float i) throws ClassCastException {
		addRequestedValue(t,new Double(i));
		modifier.requestValue(uid,i);
	}
	public void setRequestedValue(long t, double i) throws ClassCastException {
		addRequestedValue(t,new Double(i));
		modifier.requestValue(uid,i);
	}
	public void setRequestedValue(long t, Object newval) throws ClassCastException {
		if (modifier_type == STRING) {
			addRequestedValue(t,(String)newval);
		} else {
			addRequestedValue(t,new Double(((Number)newval).doubleValue()));
		}
		modifier.requestValue(uid,newval);
	}
	
	public void setMeasuredValue(long t, int i) throws ClassCastException {
		addMeasuredValue(t,new Double(i));
	}
	public void setMeasuredValue(long t, long i) throws ClassCastException {
		addMeasuredValue(t,new Double(i));
	}
	public void setMeasuredValue(long t, float i) throws ClassCastException {
		addMeasuredValue(t,new Double(i));
	}
	public void setMeasuredValue(long t, double i) throws ClassCastException {
		addMeasuredValue(t,new Double(i));
	}
	public void setMeasuredValue(long t, Object newval) throws ClassCastException {
		if (measured_type == STRING) {
			addMeasuredValue(t,(String)newval);
		} else {
			addMeasuredValue(t,new Double(((Number)newval).doubleValue()));
		}
	}
}