/**********************************************************************
 * Copyright (c) 2003,2004 Scapa Technologies Limited and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.statistical.ui.widgets.spinner.internal;


import java.util.*;

import org.eclipse.hyades.statistical.ui.EditorPlugin;
import org.eclipse.hyades.statistical.ui.widgets.internal.GData;
import org.eclipse.swt.layout.*;
import org.eclipse.swt.widgets.*;

public class DateSpinner extends Composite {

	Spinner year_spinner;
	Spinner month_spinner;
	Spinner day_spinner;
	Spinner hour_spinner;
	Spinner minute_spinner;
	Spinner second_spinner;
	Spinner msecond_spinner;

	boolean msecond = true;

	public DateSpinner(Composite parent, int style, boolean has_msec) {
		super(parent,style);
		msecond = has_msec;
		init();
	}

	public DateSpinner(Composite parent, int style) {
		super(parent,style);
		init();
	}

	public void setDate(long t) {
		Date d = new Date(t);
		DateSpinnerGregorianCalendar gc = new DateSpinnerGregorianCalendar();
		gc.setTime(d);
		
		year_spinner.setValue(gc.get(Calendar.YEAR));
		month_spinner.setValue(gc.get(Calendar.MONTH)+1);
		day_spinner.setValue(gc.get(Calendar.DAY_OF_MONTH));
		hour_spinner.setValue(gc.get(Calendar.HOUR_OF_DAY));
		minute_spinner.setValue(gc.get(Calendar.MINUTE));
		second_spinner.setValue(gc.get(Calendar.SECOND));
		if (msecond) {
			msecond_spinner.setValue(gc.get(Calendar.MILLISECOND));
		}
	}
	
	public long getDate() {
		DateSpinnerGregorianCalendar gc = new DateSpinnerGregorianCalendar();

		gc.set(Calendar.YEAR,(int)year_spinner.getValue());
		gc.set(Calendar.MONTH,(int)month_spinner.getValue()-1);
		gc.set(Calendar.DAY_OF_MONTH,(int)day_spinner.getValue());
		gc.set(Calendar.HOUR_OF_DAY,(int)hour_spinner.getValue());
		gc.set(Calendar.MINUTE,(int)minute_spinner.getValue());
		gc.set(Calendar.SECOND,(int)second_spinner.getValue());
		if (msecond) {
			gc.set(Calendar.MILLISECOND,(int)msecond_spinner.getValue());
		}

		return gc.getTimeInMillis();
	}
	
	private void init() {

//		GridLayout glayout = new GridLayout();
//		glayout.numColumns = 1;
//		setLayout(glayout);

//		date_panel = new Composite(main_panel,0);
//		date_panel.setLayoutData(GData.getGridData(true,false,-1,25,1,1,GridData.FILL,GridData.FILL));

		Composite date_panel = this;

		GridLayout glayout = new GridLayout();
		if (msecond) {
			glayout.numColumns = 9;
		} else {
			glayout.numColumns = 7;
		}

		date_panel.setLayout(glayout);
//		date_panel.setLayout(new RowLayout());

		Label label;
		label = new Label(date_panel,0);
		label.setText(EditorPlugin.getString("YEAR"));
		label.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.CENTER,GridData.END));
		label = new Label(date_panel,0);
		label.setText(EditorPlugin.getString("MONTH"));
		label.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.CENTER,GridData.END));
		label = new Label(date_panel,0);
		label.setText(EditorPlugin.getString("DAY"));
		label.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.CENTER,GridData.END));

		label = new Label(date_panel,0);
		label.setText("   ");
		label.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.END));

		label = new Label(date_panel,0);
		label.setText(EditorPlugin.getString("HOUR"));
		label.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.CENTER,GridData.END));
		label = new Label(date_panel,0);
		label.setText(EditorPlugin.getString("MINUTE"));
		label.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.CENTER,GridData.END));
		label = new Label(date_panel,0);
		label.setText(EditorPlugin.getString("SECOND"));
		label.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.CENTER,GridData.END));

		if (msecond) {

			label = new Label(date_panel,0);
			label.setText("   ");
			label.setLayoutData(GData.getGridData(false,false,-1,-1,1,1,GridData.CENTER,GridData.END));

			label = new Label(date_panel,0);
			label.setText(EditorPlugin.getString("MILLISECOND"));
			label.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.CENTER,GridData.END));

		}

		year_spinner = new Spinner(date_panel,0);
		year_spinner.configure(0,1970,3000,1);
		year_spinner.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.END));

		month_spinner = new Spinner(date_panel,0);
		month_spinner.configure(0,1,12,1);
		month_spinner.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.END));

		day_spinner = new Spinner(date_panel,0);
		day_spinner.configure(0,1,31,1);
		day_spinner.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.END));

		new Label(date_panel,0).setText("   ");

		hour_spinner = new Spinner(date_panel,0);
		hour_spinner.configure(0,0,23,1);
		hour_spinner.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.END));

		minute_spinner = new Spinner(date_panel,0);
		minute_spinner.configure(0,0,59,1);
		minute_spinner.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.END));

		second_spinner = new Spinner(date_panel,0);
		second_spinner.configure(0,0,59,1);
		second_spinner.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.END));

		if (msecond) {

			new Label(date_panel,0).setText("   ");
	
			msecond_spinner = new Spinner(date_panel,0);
			msecond_spinner.configure(0,0,999,1);
			msecond_spinner.setLayoutData(GData.getGridData(true,false,-1,-1,1,1,GridData.FILL,GridData.END));
		
		}
    
    	setDate(System.currentTimeMillis());
	}
	
	// Had to extend GregorianCalendar because under JVM 1.3 getTimeInMillis method is protected
	class DateSpinnerGregorianCalendar extends GregorianCalendar
	{
		public long getTimeInMillis()
		{
			return super.getTimeInMillis();
		}
	}
}