/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.common.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.hyades.models.common.common.CMNAnnotation;
import org.eclipse.hyades.models.common.common.CMNNamedElement;
import org.eclipse.hyades.models.common.common.CommonPackage;
import org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceImpl;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.util.FileUtil;
import org.eclipse.hyades.models.common.util.ResourceUtil;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CMN Annotation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.common.impl.CMNAnnotationImpl#getURI <em>URI</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.common.impl.CMNAnnotationImpl#getType <em>Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CMNAnnotationImpl extends CMNNamedElementImpl implements CMNAnnotation {
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = "";

    /**
     * The default value of the '{@link #getURI() <em>URI</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getURI()
     * @generated
     * @ordered
     */
	protected static final String URI_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getURI() <em>URI</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getURI()
     * @generated
     * @ordered
     */
	protected String uri = URI_EDEFAULT;

    /**
     * The default value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
	protected static final String TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
	protected String type = TYPE_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected CMNAnnotationImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EClass eStaticClass()
    {
        return CommonPackage.eINSTANCE.getCMNAnnotation();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String getURI()
    {
        return uri;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setURI(String newURI)
    {
        String oldURI = uri;
        uri = newURI;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, CommonPackage.CMN_ANNOTATION__URI, oldURI, uri));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String getType()
    {
        return type;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setType(String newType)
    {
        String oldType = type;
        type = newType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, CommonPackage.CMN_ANNOTATION__TYPE, oldType, type));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case CommonPackage.CMN_ANNOTATION__ID:
                return getId();
            case CommonPackage.CMN_ANNOTATION__DESCRIPTION:
                return getDescription();
            case CommonPackage.CMN_ANNOTATION__NAME:
                return getName();
            case CommonPackage.CMN_ANNOTATION__URI:
                return getURI();
            case CommonPackage.CMN_ANNOTATION__TYPE:
                return getType();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eSet(EStructuralFeature eFeature, Object newValue)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case CommonPackage.CMN_ANNOTATION__ID:
                setId((String)newValue);
                return;
            case CommonPackage.CMN_ANNOTATION__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case CommonPackage.CMN_ANNOTATION__NAME:
                setName((String)newValue);
                return;
            case CommonPackage.CMN_ANNOTATION__URI:
                setURI((String)newValue);
                return;
            case CommonPackage.CMN_ANNOTATION__TYPE:
                setType((String)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eUnset(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case CommonPackage.CMN_ANNOTATION__ID:
                setId(ID_EDEFAULT);
                return;
            case CommonPackage.CMN_ANNOTATION__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case CommonPackage.CMN_ANNOTATION__NAME:
                setName(NAME_EDEFAULT);
                return;
            case CommonPackage.CMN_ANNOTATION__URI:
                setURI(URI_EDEFAULT);
                return;
            case CommonPackage.CMN_ANNOTATION__TYPE:
                setType(TYPE_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean eIsSet(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case CommonPackage.CMN_ANNOTATION__ID:
                return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
            case CommonPackage.CMN_ANNOTATION__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case CommonPackage.CMN_ANNOTATION__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case CommonPackage.CMN_ANNOTATION__URI:
                return URI_EDEFAULT == null ? uri != null : !URI_EDEFAULT.equals(uri);
            case CommonPackage.CMN_ANNOTATION__TYPE:
                return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (URI: ");
        result.append(uri);
        result.append(", type: ");
        result.append(type);
        result.append(')');
        return result.toString();
    }

	public static final String ANNOTATION_QUERY = "annotationID=/";

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAnnotation#getFileAnnotation()
	 */
	public URI getFileAnnotation() throws UnsupportedOperationException, IOException {
		if ( !isFileAnnotation() )
			throw new UnsupportedOperationException("Annotation is not a File Annotation " + toString());
		String uriString = getURI();

		if ( !(this.eResource() instanceof FacadeResourceImpl))
			throw new UnsupportedOperationException("Resource is not supported by FacadeResourceImpl");
		
		FacadeResourceImpl resource = (FacadeResourceImpl) this.eResource();

		// Get the directory for all annotations on this entire resource 
		File annotationDir = resource.getAnnotationDir();
		
		URI baseAnnotationDirURI = URI.createFileURI(annotationDir.getAbsolutePath());
		URI annotation = URI.createURI(uriString);
		annotation = queryURItoRelativeURI(annotation);
		URI resolvedURI = annotation.resolve(baseAnnotationDirURI);
		
		return resolvedURI;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAnnotation#isFileAnnotation()
	 */
	public boolean isFileAnnotation() {
		if ( this.eResource() instanceof FacadeResourceImpl)
		{
			String uriString = getURI();
			if ( uriString == null || uriString.length() == 0 )
				return false;
			
			URI uri = URI.createURI(uriString);
			uri = queryURItoRelativeURI(uri);
			if ( uri.isFile() )
				return true;
		}
		
		return false;
	}
	
	/**
	 * @param uri2
	 */
	private URI queryURItoRelativeURI(URI uri) {
		
		if ( uri.hasQuery() )
		{
			String query = uri.query();
			String uriString = query.replaceFirst(ANNOTATION_QUERY, "");
			uri = URI.createURI(uriString);
		}
		return uri;
	}
	
	private URI relativeURItoQueryURI(URI uri) {
		
		if ( !uri.hasQuery() )
		{
			String queryString = ANNOTATION_QUERY + uri.toString();
			uri = URI.createHierarchicalURI(null, null, null, queryString, null);			
		}
		return uri;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAnnotation#putFileAnnotation(org.eclipse.emf.common.util.URI)
	 */
	public void putFileAnnotation(URI file) throws UnsupportedOperationException, IOException {
		
		if ( !(this.eResource() instanceof FacadeResourceImpl))
			throw new UnsupportedOperationException("Resource is not supported by FacadeResourceImpl");
		
		// Get the model GUID of the container object. 
		String containerID = getContainerID();
		
		FacadeResourceImpl resource = (FacadeResourceImpl) this.eResource();

		// Get the directory for all annotations on this entire resource 
		File annotationDir = resource.getAnnotationDir();
		
		// Either create or verify the existance of a subdirectory for
		// storing all annotations of this particular model element
		File objectAnnotationDir = new File(annotationDir, containerID);
		if ( !objectAnnotationDir.exists() )
		{
			if (!objectAnnotationDir.mkdir())
			{
				throw new IOException("Collision making dirctory " + objectAnnotationDir.getAbsolutePath());
			}
		}
		else if ( !objectAnnotationDir.isDirectory())
		{
			throw new IOException("Object annotation dir name exists as file " + objectAnnotationDir.getAbsolutePath());
		}
		
		// we now know that objectAnnotationDir exists and is a directory.
		File srcFile = new File(file.toFileString());
		if ( !srcFile.exists() )
		{
			throw new IOException("Specified file does not exist " + file.toFileString());
		}

		File destFile = new File(objectAnnotationDir, srcFile.getName());
		if ( destFile.exists() )
		{
			throw new IOException("FileAnnotation of same name (" + srcFile.getName() + ") already exists on object " + this.eContainer().toString());
		}
		
		// Copy the file annotation into our container object's annotation directory
		FileUtil.copyFile(srcFile.getAbsolutePath(), destFile.getAbsolutePath());
		
		URI baseAnnotationDirURI = URI.createFileURI(annotationDir.getAbsolutePath());
		URI annotation = URI.createFileURI(destFile.getAbsolutePath());
		URI relativeURI = annotation.deresolve(baseAnnotationDirURI);
		
		setURI(relativeURItoQueryURI(relativeURI).toString());		
		
	}

	/**
	 * @throws UnsupportedOperationException
	 */
	private String getContainerID() throws UnsupportedOperationException {
		String containerID;
		EObject container = this.eContainer();
		
		if ( container == null )
		{
			throw new UnsupportedOperationException("FileAnnotation must be contained in a model element");
		}
		
		if ( container instanceof CMNNamedElement )
		{
			CMNNamedElement con = (CMNNamedElement) container;
			containerID = con.getId();
		}
		else if ( container instanceof TPFExecutionEvent )
		{
			TPFExecutionEvent con = (TPFExecutionEvent) container;
			containerID = con.getId();
		}
		else
		{
			throw new UnsupportedOperationException("Annotations not supported for container of type " + container);
		}
		return containerID;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IAnnotation#removeFileAnnotation()
	 */
	public void removeFileAnnotation() throws UnsupportedOperationException, IOException {

		URI resolvedURI = getFileAnnotation();
		File file = new File(resolvedURI.toFileString());
		try {
			if (file.exists())
			{
				file.delete();
				File parentDir = file.getParentFile();
				if ( parentDir.exists())
				{
					File[] siblings = parentDir.listFiles();
					if ( siblings.length == 0 )
					{
						// Removed the only annotation of the model element. 
						// Delete the subdirectory
						parentDir.delete();
					}
				}
			}
		}
		finally {
			setURI(URI_EDEFAULT);
		}
	}
} //CMNAnnotationImpl
