/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGInstance;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.facades.behavioral.IVariable;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.impl.FacadeUtil;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CFG Instance</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl#getLifeline <em>Lifeline</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl#getTestCase <em>Test Case</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl#getMaxCount <em>Max Count</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl#getInitialValue <em>Initial Value</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl#getClassOwner <em>Class Owner</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGInstanceImpl#getClassType <em>Class Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CFGInstanceImpl extends CMNNamedElementImpl implements CFGInstance
{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = "";

    /**
     * The cached value of the '{@link #getLifeline() <em>Lifeline</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getLifeline()
     * @generated
     * @ordered
     */
	protected BVRLifeline lifeline = null;

    /**
     * The default value of the '{@link #getMaxCount() <em>Max Count</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getMaxCount()
     * @generated
     * @ordered
     */
	protected static final int MAX_COUNT_EDEFAULT = 0;

    /**
     * The cached value of the '{@link #getMaxCount() <em>Max Count</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getMaxCount()
     * @generated
     * @ordered
     */
	protected int maxCount = MAX_COUNT_EDEFAULT;

    /**
     * The default value of the '{@link #getInitialValue() <em>Initial Value</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getInitialValue()
     * @generated
     * @ordered
     */
	protected static final String INITIAL_VALUE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getInitialValue() <em>Initial Value</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getInitialValue()
     * @generated
     * @ordered
     */
	protected String initialValue = INITIAL_VALUE_EDEFAULT;

    /**
     * The cached value of the '{@link #getClassType() <em>Class Type</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getClassType()
     * @generated
     * @ordered
     */
	protected CFGClass classType = null;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected CFGInstanceImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EClass eStaticClass()
    {
        return Common_ConfigurationPackage.eINSTANCE.getCFGInstance();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public int getMaxCount()
    {
        return maxCount;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setMaxCount(int newMaxCount)
    {
        int oldMaxCount = maxCount;
        maxCount = newMaxCount;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__MAX_COUNT, oldMaxCount, maxCount));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String getInitialValue()
    {
        return initialValue;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setInitialValue(String newInitialValue)
    {
        String oldInitialValue = initialValue;
        initialValue = newInitialValue;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__INITIAL_VALUE, oldInitialValue, initialValue));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public BVRLifeline getLifeline()
    {
        if (lifeline != null && lifeline.eIsProxy())
        {
            BVRLifeline oldLifeline = lifeline;
            lifeline = (BVRLifeline)eResolveProxy((InternalEObject)lifeline);
            if (lifeline != oldLifeline)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE, oldLifeline, lifeline));
            }
        }
        return lifeline;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public BVRLifeline basicGetLifeline()
    {
        return lifeline;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetLifeline(BVRLifeline newLifeline, NotificationChain msgs)
    {
        BVRLifeline oldLifeline = lifeline;
        lifeline = newLifeline;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE, oldLifeline, newLifeline);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setLifeline(BVRLifeline newLifeline)
    {
        if (newLifeline != lifeline)
        {
            NotificationChain msgs = null;
            if (lifeline != null)
                msgs = ((InternalEObject)lifeline).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INSTANCES, BVRLifeline.class, msgs);
            if (newLifeline != null)
                msgs = ((InternalEObject)newLifeline).eInverseAdd(this, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INSTANCES, BVRLifeline.class, msgs);
            msgs = basicSetLifeline(newLifeline, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE, newLifeline, newLifeline));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFTestCase getTestCase()
    {
        if (eContainerFeatureID != Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE) return null;
        return (TPFTestCase)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setTestCase(TPFTestCase newTestCase)
    {
        if (newTestCase != eContainer || (eContainerFeatureID != Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE && newTestCase != null))
        {
            if (EcoreUtil.isAncestor(this, newTestCase))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newTestCase != null)
                msgs = ((InternalEObject)newTestCase).eInverseAdd(this, Common_TestprofilePackage.TPF_TEST_CASE__INSTANCES, TPFTestCase.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newTestCase, Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE, newTestCase, newTestCase));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public CFGClass getClassOwner()
    {
        if (eContainerFeatureID != Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER) return null;
        return (CFGClass)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setClassOwner(CFGClass newClassOwner)
    {
        if (newClassOwner != eContainer || (eContainerFeatureID != Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER && newClassOwner != null))
        {
            if (EcoreUtil.isAncestor(this, newClassOwner))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newClassOwner != null)
                msgs = ((InternalEObject)newClassOwner).eInverseAdd(this, Common_ConfigurationPackage.CFG_CLASS__INSTANCES, CFGClass.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newClassOwner, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER, newClassOwner, newClassOwner));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public CFGClass getClassType()
    {
        if (classType != null && classType.eIsProxy())
        {
            CFGClass oldClassType = classType;
            classType = (CFGClass)eResolveProxy((InternalEObject)classType);
            if (classType != oldClassType)
            {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE, oldClassType, classType));
            }
        }
        return classType;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public CFGClass basicGetClassType()
    {
        return classType;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetClassType(CFGClass newClassType, NotificationChain msgs)
    {
        CFGClass oldClassType = classType;
        classType = newClassType;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE, oldClassType, newClassType);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setClassType(CFGClass newClassType)
    {
        if (newClassType != classType)
        {
            NotificationChain msgs = null;
            if (classType != null)
                msgs = ((InternalEObject)classType).eInverseRemove(this, Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS, CFGClass.class, msgs);
            if (newClassType != null)
                msgs = ((InternalEObject)newClassType).eInverseAdd(this, Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS, CFGClass.class, msgs);
            msgs = basicSetClassType(newClassType, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE, newClassType, newClassType));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE:
                    if (lifeline != null)
                        msgs = ((InternalEObject)lifeline).eInverseRemove(this, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INSTANCES, BVRLifeline.class, msgs);
                    return basicSetLifeline((BVRLifeline)otherEnd, msgs);
                case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE, msgs);
                case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER, msgs);
                case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE:
                    if (classType != null)
                        msgs = ((InternalEObject)classType).eInverseRemove(this, Common_ConfigurationPackage.CFG_CLASS__INSTANTIATIONS, CFGClass.class, msgs);
                    return basicSetClassType((CFGClass)otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE:
                    return basicSetLifeline(null, msgs);
                case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
                    return eBasicSetContainer(null, Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE, msgs);
                case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
                    return eBasicSetContainer(null, Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER, msgs);
                case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE:
                    return basicSetClassType(null, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs)
    {
        if (eContainerFeatureID >= 0)
        {
            switch (eContainerFeatureID)
            {
                case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
                    return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_TEST_CASE__INSTANCES, TPFTestCase.class, msgs);
                case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
                    return ((InternalEObject)eContainer).eInverseRemove(this, Common_ConfigurationPackage.CFG_CLASS__INSTANCES, CFGClass.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_ConfigurationPackage.CFG_INSTANCE__ID:
                return getId();
            case Common_ConfigurationPackage.CFG_INSTANCE__DESCRIPTION:
                return getDescription();
            case Common_ConfigurationPackage.CFG_INSTANCE__NAME:
                return getName();
            case Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE:
                if (resolve) return getLifeline();
                return basicGetLifeline();
            case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
                return getTestCase();
            case Common_ConfigurationPackage.CFG_INSTANCE__MAX_COUNT:
                return new Integer(getMaxCount());
            case Common_ConfigurationPackage.CFG_INSTANCE__INITIAL_VALUE:
                return getInitialValue();
            case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
                return getClassOwner();
            case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE:
                if (resolve) return getClassType();
                return basicGetClassType();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eSet(EStructuralFeature eFeature, Object newValue)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_ConfigurationPackage.CFG_INSTANCE__ID:
                setId((String)newValue);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__NAME:
                setName((String)newValue);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE:
                setLifeline((BVRLifeline)newValue);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
                setTestCase((TPFTestCase)newValue);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__MAX_COUNT:
                setMaxCount(((Integer)newValue).intValue());
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__INITIAL_VALUE:
                setInitialValue((String)newValue);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
                setClassOwner((CFGClass)newValue);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE:
                setClassType((CFGClass)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eUnset(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_ConfigurationPackage.CFG_INSTANCE__ID:
                setId(ID_EDEFAULT);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__NAME:
                setName(NAME_EDEFAULT);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE:
                setLifeline((BVRLifeline)null);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
                setTestCase((TPFTestCase)null);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__MAX_COUNT:
                setMaxCount(MAX_COUNT_EDEFAULT);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__INITIAL_VALUE:
                setInitialValue(INITIAL_VALUE_EDEFAULT);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
                setClassOwner((CFGClass)null);
                return;
            case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE:
                setClassType((CFGClass)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean eIsSet(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_ConfigurationPackage.CFG_INSTANCE__ID:
                return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
            case Common_ConfigurationPackage.CFG_INSTANCE__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case Common_ConfigurationPackage.CFG_INSTANCE__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case Common_ConfigurationPackage.CFG_INSTANCE__LIFELINE:
                return lifeline != null;
            case Common_ConfigurationPackage.CFG_INSTANCE__TEST_CASE:
                return getTestCase() != null;
            case Common_ConfigurationPackage.CFG_INSTANCE__MAX_COUNT:
                return maxCount != MAX_COUNT_EDEFAULT;
            case Common_ConfigurationPackage.CFG_INSTANCE__INITIAL_VALUE:
                return INITIAL_VALUE_EDEFAULT == null ? initialValue != null : !INITIAL_VALUE_EDEFAULT.equals(initialValue);
            case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_OWNER:
                return getClassOwner() != null;
            case Common_ConfigurationPackage.CFG_INSTANCE__CLASS_TYPE:
                return classType != null;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (maxCount: ");
        result.append(maxCount);
        result.append(", initialValue: ");
        result.append(initialValue);
        result.append(')');
        return result.toString();
    }

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IVariable#getType()
	 */
	public String getType() {
		CFGClassImpl type = (CFGClassImpl)getClassType();
		return type.getName();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IVariable#setType(java.lang.String)
	 */
	public void setType(String type) {
		CFGClassImpl cls = (CFGClassImpl)FacadeUtil.INSTANCE.getType(type, (ITest)getTestCase());
		setClassType(cls);
	}

} //CFGInstanceImpl
