/*******************************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

import org.eclipse.emf.common.util.URI;


/**
 * This interface defines any component that is part of a project.
 * 
 * @author bjiang
 * @author jtoomey
 */
public interface IProjectBasedComponent
{
    /**
     * Returns the project of this component.
     * 
     * @return the project
     */
    public String getProject();
    
    /**
     * Returns the platform relative URI. The result will be of this form: <br>
     * platform:/resource/project-name/path
     * @return the platform relative URI.
     */
    public URI getPlatformURI();
	
}
