/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral;

/**
 * 
 * A test case is a specification of one way to test a system, including what to 
 * test with which input, result, and under which conditions.  A test case 
 * belongs to one and only one test suite.  The test suite has the behavior 
 * specifying how a set of cooperating test components will interact with a 
 * system under test for this test case.  Test cases may invoke other test 
 * cases or test suites through test invocation actions.  A test case uses an 
 * arbiter to evaluate the outcome of its test behavior.
 * 
 * @author jtoomey
 * @author serge
 * @author marcelop
 * @author psun
 * @since 0.0.1
 */
// todo> JPT> Do we need to manage the arbiter, and if we don't, who does?
public interface ITestCase extends ITest {
	/**
	 * Returns the test suite that contains this test case.
	 * 
	 * <p>This reference is bidirectional and its opposite is 
	 * {@link ITestSuite#getTestCases()}.
	 * 
	 * @return ITestSuite
	 */
	public ITestSuite getOwner();	
}
