/*******************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.common.common.CMNNamedElement;

/**
 * Extends {@link org.eclipse.hyades.models.common.facades.behavioral.impl.FacadeResourceImpl FacadeResourceImpl}
 * to improve performance of datapool loading by caching EObjects with their IDs during loading.
 * 
 * @author bjiang
 * @since  3.0.2
 */
public class DatapoolFacadeResourceImpl extends FacadeResourceImpl {

	/**
	 * A cache that maps EObject and its ID which will be populated and used only during loading
	 * to improve model loading performance. 
	 */
	private Hashtable eObjectIDCache = new Hashtable();	
	private boolean modelLoaded;
	
	public DatapoolFacadeResourceImpl() {
		super();
	}
	/**
	 * @param arg0
	 */
	public DatapoolFacadeResourceImpl(URI arg0) {
		super(arg0);
	}	
	
	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.resource.Resource.Internal#attached(org.eclipse.emf.ecore.EObject)
	 */
	public void attached(EObject arg0) {
		super.attached(arg0);
		
		// populate the cache
		if(arg0 instanceof CMNNamedElement)		
			eObjectIDCache.put(((CMNNamedElement)arg0).getId(), arg0);
		if(modelLoaded == true)
			modelLoaded = false;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#doLoad(java.io.InputStream, java.util.Map)
	 */
	public void doLoad(InputStream inputStream, Map options) throws IOException {
		super.doLoad(inputStream, options);
		// model finished loading, clear the cache used during loading.
		modelLoaded = true;
		eObjectIDCache.clear();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#getEObjectByID(java.lang.String)
	 */
	protected EObject getEObjectByID(String id) {
		EObject eObject;
		// only use the cache for searching during loading. After model loaded, use conventional.
		if(modelLoaded)
			eObject = super.getEObjectByID(id);
		else
			eObject = (EObject)eObjectIDCache.get(id);
		return eObject;
	}
}
