/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.interactions;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>BVR Event Occurrence</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * EventOccurrences represents moments in time to which Actions are associated. An EventOccurrence is the basic
 * semantic unit of Interactions. The sequences of Eventoccurrences are the meanings of Interactions. Messages are sent
 * through either asynchronous signal sending or operation calls. Likewise they are recieved by Receptions or actions of
 * consumption.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getTargetGeneralOrderings <em>Target General Orderings</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getSourceGeneralOrderings <em>Source General Orderings</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getFinishExecutionOccurrence <em>Finish Execution Occurrence</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getStartExecutionOcurrence <em>Start Execution Ocurrence</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVREventOccurrence()
 * @model 
 * @generated
 */
public interface BVREventOccurrence extends BVRInteractionFragment{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String copyright = "";

    /**
     * Returns the value of the '<em><b>Target General Orderings</b></em>' reference list.
     * The list contents are of type {@link org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering}.
     * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering#getPreviousEventOccurrence <em>Previous Event Occurrence</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Target General Orderings</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Target General Orderings</em>' reference list.
     * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVREventOccurrence_TargetGeneralOrderings()
     * @see org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering#getPreviousEventOccurrence
     * @model type="org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering" opposite="previousEventOccurrence"
     * @generated
     */
	EList getTargetGeneralOrderings();

    /**
     * Returns the value of the '<em><b>Source General Orderings</b></em>' reference list.
     * The list contents are of type {@link org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering}.
     * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering#getNextEventOccurence <em>Next Event Occurence</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Source General Orderings</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Source General Orderings</em>' reference list.
     * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVREventOccurrence_SourceGeneralOrderings()
     * @see org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering#getNextEventOccurence
     * @model type="org.eclipse.hyades.models.common.interactions.BVRGeneralOrdering" opposite="nextEventOccurence"
     * @generated
     */
	EList getSourceGeneralOrderings();

    /**
     * Returns the value of the '<em><b>Finish Execution Occurrence</b></em>' reference.
     * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence#getFinishEventOccurrence <em>Finish Event Occurrence</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Finish Execution Occurrence</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Finish Execution Occurrence</em>' reference.
     * @see #setFinishExecutionOccurrence(BVRExecutionOccurrence)
     * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVREventOccurrence_FinishExecutionOccurrence()
     * @see org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence#getFinishEventOccurrence
     * @model opposite="finishEventOccurrence"
     * @generated
     */
	BVRExecutionOccurrence getFinishExecutionOccurrence();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getFinishExecutionOccurrence <em>Finish Execution Occurrence</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Finish Execution Occurrence</em>' reference.
     * @see #getFinishExecutionOccurrence()
     * @generated
     */
	void setFinishExecutionOccurrence(BVRExecutionOccurrence value);

    /**
     * Returns the value of the '<em><b>Start Execution Ocurrence</b></em>' reference.
     * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence#getBeforeEventOccurrence <em>Before Event Occurrence</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Start Execution Ocurrence</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Start Execution Ocurrence</em>' reference.
     * @see #setStartExecutionOcurrence(BVRExecutionOccurrence)
     * @see org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage#getBVREventOccurrence_StartExecutionOcurrence()
     * @see org.eclipse.hyades.models.common.interactions.BVRExecutionOccurrence#getBeforeEventOccurrence
     * @model opposite="beforeEventOccurrence"
     * @generated
     */
	BVRExecutionOccurrence getStartExecutionOcurrence();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.interactions.BVREventOccurrence#getStartExecutionOcurrence <em>Start Execution Ocurrence</em>}' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Start Execution Ocurrence</em>' reference.
     * @see #getStartExecutionOcurrence()
     * @generated
     */
	void setStartExecutionOcurrence(BVRExecutionOccurrence value);

} // BVREventOccurrence
