/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.common.configuration.CFGClass;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>TPF Arbiter</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * An Arbiter represents an implementation of the IArbiter interface. The purpose of an IArbiter implementation is to determine the final verdict for a test case. This determination is done according to a particular arbitration strategy, which is provided in the implementation of the arbiter interface.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFArbiter#getBehaviors <em>Behaviors</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.TPFArbiter#getTestSuite <em>Test Suite</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFArbiter()
 * @model 
 * @generated
 */
public interface TPFArbiter extends CFGClass{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	String copyright = "";

    /**
     * Returns the value of the '<em><b>Behaviors</b></em>' containment reference list.
     * The list contents are of type {@link org.eclipse.hyades.models.common.testprofile.TPFBehavior}.
     * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFBehavior#getArbiter <em>Arbiter</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Behaviors</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Behaviors</em>' containment reference list.
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFArbiter_Behaviors()
     * @see org.eclipse.hyades.models.common.testprofile.TPFBehavior#getArbiter
     * @model type="org.eclipse.hyades.models.common.testprofile.TPFBehavior" opposite="arbiter" containment="true" required="true"
     * @generated
     */
	EList getBehaviors();

    /**
     * Returns the value of the '<em><b>Test Suite</b></em>' container reference.
     * It is bidirectional and its opposite is '{@link org.eclipse.hyades.models.common.testprofile.TPFTestSuite#getArbiter <em>Arbiter</em>}'.
     * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Test Suite</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
     * @return the value of the '<em>Test Suite</em>' container reference.
     * @see #setTestSuite(TPFTestSuite)
     * @see org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage#getTPFArbiter_TestSuite()
     * @see org.eclipse.hyades.models.common.testprofile.TPFTestSuite#getArbiter
     * @model opposite="arbiter"
     * @generated
     */
	TPFTestSuite getTestSuite();

    /**
     * Sets the value of the '{@link org.eclipse.hyades.models.common.testprofile.TPFArbiter#getTestSuite <em>Test Suite</em>}' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Test Suite</em>' container reference.
     * @see #getTestSuite()
     * @generated
     */
	void setTestSuite(TPFTestSuite value);

} // TPFArbiter
