/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.facades.behavioral.IImplementor;
import org.eclipse.hyades.models.common.facades.behavioral.ITest;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTest;
import org.eclipse.hyades.models.common.testprofile.TPFTestObjective;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Test</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestImpl#getTestObjectives <em>Test Objectives</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFTestImpl#getBehavior <em>Behavior</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class TPFTestImpl extends CMNNamedElementImpl implements TPFTest
{
    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public static final String copyright = "";

    /**
     * The default value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
	protected static final String TYPE_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getType()
     * @generated
     * @ordered
     */
	protected String type = TYPE_EDEFAULT;

    /**
     * The cached value of the '{@link #getTestObjectives() <em>Test Objectives</em>}' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getTestObjectives()
     * @generated
     * @ordered
     */
	protected EList testObjectives = null;

    /**
     * The cached value of the '{@link #getBehavior() <em>Behavior</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see #getBehavior()
     * @generated
     * @ordered
     */
	protected TPFBehavior behavior = null;

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected TPFTestImpl()
    {
        super();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected EClass eStaticClass()
    {
        return Common_TestprofilePackage.eINSTANCE.getTPFTest();
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String getType()
    {
        return type;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setType(String newType)
    {
        String oldType = type;
        type = newType;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST__TYPE, oldType, type));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public EList getTestObjectives()
    {
        if (testObjectives == null)
        {
            testObjectives = new EObjectContainmentWithInverseEList(TPFTestObjective.class, this, Common_TestprofilePackage.TPF_TEST__TEST_OBJECTIVES, Common_TestprofilePackage.TPF_TEST_OBJECTIVE__TEST);
        }
        return testObjectives;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public TPFBehavior getBehavior()
    {
        return behavior;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain basicSetBehavior(TPFBehavior newBehavior, NotificationChain msgs)
    {
        TPFBehavior oldBehavior = behavior;
        behavior = newBehavior;
        if (eNotificationRequired())
        {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST__BEHAVIOR, oldBehavior, newBehavior);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void setBehavior(TPFBehavior newBehavior)
    {
        if (newBehavior != behavior)
        {
            NotificationChain msgs = null;
            if (behavior != null)
                msgs = ((InternalEObject)behavior).eInverseRemove(this, Common_TestprofilePackage.TPF_BEHAVIOR__TEST, TPFBehavior.class, msgs);
            if (newBehavior != null)
                msgs = ((InternalEObject)newBehavior).eInverseAdd(this, Common_TestprofilePackage.TPF_BEHAVIOR__TEST, TPFBehavior.class, msgs);
            msgs = basicSetBehavior(newBehavior, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_TEST__BEHAVIOR, newBehavior, newBehavior));
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_TestprofilePackage.TPF_TEST__TEST_OBJECTIVES:
                    return ((InternalEList)getTestObjectives()).basicAdd(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST__BEHAVIOR:
                    if (behavior != null)
                        msgs = ((InternalEObject)behavior).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - Common_TestprofilePackage.TPF_TEST__BEHAVIOR, null, msgs);
                    return basicSetBehavior((TPFBehavior)otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs)
    {
        if (featureID >= 0)
        {
            switch (eDerivedStructuralFeatureID(featureID, baseClass))
            {
                case Common_TestprofilePackage.TPF_TEST__TEST_OBJECTIVES:
                    return ((InternalEList)getTestObjectives()).basicRemove(otherEnd, msgs);
                case Common_TestprofilePackage.TPF_TEST__BEHAVIOR:
                    return basicSetBehavior(null, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Object eGet(EStructuralFeature eFeature, boolean resolve)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_TEST__ID:
                return getId();
            case Common_TestprofilePackage.TPF_TEST__DESCRIPTION:
                return getDescription();
            case Common_TestprofilePackage.TPF_TEST__NAME:
                return getName();
            case Common_TestprofilePackage.TPF_TEST__TYPE:
                return getType();
            case Common_TestprofilePackage.TPF_TEST__TEST_OBJECTIVES:
                return getTestObjectives();
            case Common_TestprofilePackage.TPF_TEST__BEHAVIOR:
                return getBehavior();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eSet(EStructuralFeature eFeature, Object newValue)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_TEST__ID:
                setId((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST__DESCRIPTION:
                setDescription((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST__NAME:
                setName((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST__TYPE:
                setType((String)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST__TEST_OBJECTIVES:
                getTestObjectives().clear();
                getTestObjectives().addAll((Collection)newValue);
                return;
            case Common_TestprofilePackage.TPF_TEST__BEHAVIOR:
                setBehavior((TPFBehavior)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public void eUnset(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_TEST__ID:
                setId(ID_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_TEST__DESCRIPTION:
                setDescription(DESCRIPTION_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_TEST__NAME:
                setName(NAME_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_TEST__TYPE:
                setType(TYPE_EDEFAULT);
                return;
            case Common_TestprofilePackage.TPF_TEST__TEST_OBJECTIVES:
                getTestObjectives().clear();
                return;
            case Common_TestprofilePackage.TPF_TEST__BEHAVIOR:
                setBehavior((TPFBehavior)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public boolean eIsSet(EStructuralFeature eFeature)
    {
        switch (eDerivedStructuralFeatureID(eFeature))
        {
            case Common_TestprofilePackage.TPF_TEST__ID:
                return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
            case Common_TestprofilePackage.TPF_TEST__DESCRIPTION:
                return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
            case Common_TestprofilePackage.TPF_TEST__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case Common_TestprofilePackage.TPF_TEST__TYPE:
                return TYPE_EDEFAULT == null ? type != null : !TYPE_EDEFAULT.equals(type);
            case Common_TestprofilePackage.TPF_TEST__TEST_OBJECTIVES:
                return testObjectives != null && !testObjectives.isEmpty();
            case Common_TestprofilePackage.TPF_TEST__BEHAVIOR:
                return behavior != null;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public String toString()
    {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (type: ");
        result.append(type);
        result.append(')');
        return result.toString();
    }

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.ITest#getImplementor()
	 */
	public IImplementor getImplementor() {
		return (TPFBehaviorImpl)getBehavior();
	}

} //TPFTestImpl
