/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.internal.sdb.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.internal.sdb.SDBDirective;
import org.eclipse.hyades.models.internal.sdb.SDBPackage;
import org.eclipse.hyades.models.internal.sdb.SDBRuntime;
import org.eclipse.hyades.models.internal.sdb.SDBSolution;
import org.eclipse.hyades.models.internal.sdb.SDBSymptom;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Runtime</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.impl.SDBRuntimeImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.impl.SDBRuntimeImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.impl.SDBRuntimeImpl#getSymptomUrl <em>Symptom Url</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.impl.SDBRuntimeImpl#getLocalExternalFileLocation <em>Local External File Location</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.impl.SDBRuntimeImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.impl.SDBRuntimeImpl#getSymptoms <em>Symptoms</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.impl.SDBRuntimeImpl#getSolutions <em>Solutions</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.internal.sdb.impl.SDBRuntimeImpl#getDirectives <em>Directives</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SDBRuntimeImpl extends EObjectImpl implements SDBRuntime {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getSymptomUrl() <em>Symptom Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSymptomUrl()
	 * @generated
	 * @ordered
	 */
	protected static final String SYMPTOM_URL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSymptomUrl() <em>Symptom Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSymptomUrl()
	 * @generated
	 * @ordered
	 */
	protected String symptomUrl = SYMPTOM_URL_EDEFAULT;

	/**
	 * The default value of the '{@link #getLocalExternalFileLocation() <em>Local External File Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocalExternalFileLocation()
	 * @generated
	 * @ordered
	 */
	protected static final String LOCAL_EXTERNAL_FILE_LOCATION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLocalExternalFileLocation() <em>Local External File Location</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocalExternalFileLocation()
	 * @generated
	 * @ordered
	 */
	protected String localExternalFileLocation = LOCAL_EXTERNAL_FILE_LOCATION_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getSymptoms() <em>Symptoms</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSymptoms()
	 * @generated
	 * @ordered
	 */
	protected EList symptoms = null;

	/**
	 * The cached value of the '{@link #getSolutions() <em>Solutions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSolutions()
	 * @generated
	 * @ordered
	 */
	protected EList solutions = null;

	/**
	 * The cached value of the '{@link #getDirectives() <em>Directives</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDirectives()
	 * @generated
	 * @ordered
	 */
	protected EList directives = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SDBRuntimeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return SDBPackage.eINSTANCE.getSDBRuntime();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SDBPackage.SDB_RUNTIME__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SDBPackage.SDB_RUNTIME__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSymptomUrl() {
		return symptomUrl;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSymptomUrl(String newSymptomUrl) {
		String oldSymptomUrl = symptomUrl;
		symptomUrl = newSymptomUrl;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SDBPackage.SDB_RUNTIME__SYMPTOM_URL, oldSymptomUrl, symptomUrl));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLocalExternalFileLocation() {
		return localExternalFileLocation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLocalExternalFileLocation(String newLocalExternalFileLocation) {
		String oldLocalExternalFileLocation = localExternalFileLocation;
		localExternalFileLocation = newLocalExternalFileLocation;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SDBPackage.SDB_RUNTIME__LOCAL_EXTERNAL_FILE_LOCATION, oldLocalExternalFileLocation, localExternalFileLocation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, SDBPackage.SDB_RUNTIME__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSymptoms() {
		if (symptoms == null) {
			symptoms = new EObjectContainmentEList(SDBSymptom.class, this, SDBPackage.SDB_RUNTIME__SYMPTOMS);
		}
		return symptoms;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSolutions() {
		if (solutions == null) {
			solutions = new EObjectContainmentEList(SDBSolution.class, this, SDBPackage.SDB_RUNTIME__SOLUTIONS);
		}
		return solutions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDirectives() {
		if (directives == null) {
			directives = new EObjectContainmentEList(SDBDirective.class, this, SDBPackage.SDB_RUNTIME__DIRECTIVES);
		}
		return directives;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case SDBPackage.SDB_RUNTIME__SYMPTOMS:
					return ((InternalEList)getSymptoms()).basicRemove(otherEnd, msgs);
				case SDBPackage.SDB_RUNTIME__SOLUTIONS:
					return ((InternalEList)getSolutions()).basicRemove(otherEnd, msgs);
				case SDBPackage.SDB_RUNTIME__DIRECTIVES:
					return ((InternalEList)getDirectives()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SDBPackage.SDB_RUNTIME__ID:
				return getId();
			case SDBPackage.SDB_RUNTIME__NAME:
				return getName();
			case SDBPackage.SDB_RUNTIME__SYMPTOM_URL:
				return getSymptomUrl();
			case SDBPackage.SDB_RUNTIME__LOCAL_EXTERNAL_FILE_LOCATION:
				return getLocalExternalFileLocation();
			case SDBPackage.SDB_RUNTIME__DESCRIPTION:
				return getDescription();
			case SDBPackage.SDB_RUNTIME__SYMPTOMS:
				return getSymptoms();
			case SDBPackage.SDB_RUNTIME__SOLUTIONS:
				return getSolutions();
			case SDBPackage.SDB_RUNTIME__DIRECTIVES:
				return getDirectives();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SDBPackage.SDB_RUNTIME__ID:
				setId((String)newValue);
				return;
			case SDBPackage.SDB_RUNTIME__NAME:
				setName((String)newValue);
				return;
			case SDBPackage.SDB_RUNTIME__SYMPTOM_URL:
				setSymptomUrl((String)newValue);
				return;
			case SDBPackage.SDB_RUNTIME__LOCAL_EXTERNAL_FILE_LOCATION:
				setLocalExternalFileLocation((String)newValue);
				return;
			case SDBPackage.SDB_RUNTIME__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case SDBPackage.SDB_RUNTIME__SYMPTOMS:
				getSymptoms().clear();
				getSymptoms().addAll((Collection)newValue);
				return;
			case SDBPackage.SDB_RUNTIME__SOLUTIONS:
				getSolutions().clear();
				getSolutions().addAll((Collection)newValue);
				return;
			case SDBPackage.SDB_RUNTIME__DIRECTIVES:
				getDirectives().clear();
				getDirectives().addAll((Collection)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SDBPackage.SDB_RUNTIME__ID:
				setId(ID_EDEFAULT);
				return;
			case SDBPackage.SDB_RUNTIME__NAME:
				setName(NAME_EDEFAULT);
				return;
			case SDBPackage.SDB_RUNTIME__SYMPTOM_URL:
				setSymptomUrl(SYMPTOM_URL_EDEFAULT);
				return;
			case SDBPackage.SDB_RUNTIME__LOCAL_EXTERNAL_FILE_LOCATION:
				setLocalExternalFileLocation(LOCAL_EXTERNAL_FILE_LOCATION_EDEFAULT);
				return;
			case SDBPackage.SDB_RUNTIME__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case SDBPackage.SDB_RUNTIME__SYMPTOMS:
				getSymptoms().clear();
				return;
			case SDBPackage.SDB_RUNTIME__SOLUTIONS:
				getSolutions().clear();
				return;
			case SDBPackage.SDB_RUNTIME__DIRECTIVES:
				getDirectives().clear();
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case SDBPackage.SDB_RUNTIME__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case SDBPackage.SDB_RUNTIME__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case SDBPackage.SDB_RUNTIME__SYMPTOM_URL:
				return SYMPTOM_URL_EDEFAULT == null ? symptomUrl != null : !SYMPTOM_URL_EDEFAULT.equals(symptomUrl);
			case SDBPackage.SDB_RUNTIME__LOCAL_EXTERNAL_FILE_LOCATION:
				return LOCAL_EXTERNAL_FILE_LOCATION_EDEFAULT == null ? localExternalFileLocation != null : !LOCAL_EXTERNAL_FILE_LOCATION_EDEFAULT.equals(localExternalFileLocation);
			case SDBPackage.SDB_RUNTIME__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case SDBPackage.SDB_RUNTIME__SYMPTOMS:
				return symptoms != null && !symptoms.isEmpty();
			case SDBPackage.SDB_RUNTIME__SOLUTIONS:
				return solutions != null && !solutions.isEmpty();
			case SDBPackage.SDB_RUNTIME__DIRECTIVES:
				return directives != null && !directives.isEmpty();
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", name: ");
		result.append(name);
		result.append(", symptomUrl: ");
		result.append(symptomUrl);
		result.append(", localExternalFileLocation: ");
		result.append(localExternalFileLocation);
		result.append(", description: ");
		result.append(description);
		result.append(')');
		return result.toString();
	}

} //SDBRuntimeImpl
