/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.testgen.http;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.internal.execution.testgen.TestgenException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;


/**
 * @author dhinson
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class TRCFileLoader extends DefaultHandler
{
	private XMLReader 				xmlReader;
	private FileReader 				fileReader;
	private LinkedList				list = new LinkedList();
	
	private TRCFileLoader 			handler;
	private TRCNodeAssembler		assembler;
	private TRCNodeDispatcher		dispatcher;
	
	private Testgen.ProgressUpdater	updater;
	
	private PrintStream	debugStream;
		
	public TRCFileLoader (Testgen.ProgressUpdater updater)
	{
		super();
		
		handler = this;
		this.updater = updater;
	}

	public TRCFileLoader (Testgen.ProgressUpdater updater,
		PrintStream debugStream)
	{
		super();
		
		handler = this;
		this.updater = updater;
		this.debugStream = debugStream;
	}

	public boolean load (IFile recFile, String outputFileName)
		throws TestgenException
	{
		if (recFile == null)
			throw new TestgenException(TestgenHttpPlugin.
				getResourceString("E_INVALID_REC_FILE"));
			
		// create and initialize decoding context
		TRCContext context = new TRCContext();
		File file = new File(outputFileName.toString());
		context.setOutputFolder(new Path(file.getParent()));
		String baseName = file.getName();
		baseName = baseName.substring(0, baseName.lastIndexOf('.'));
		context.setTestSuiteBaseName(baseName);
		context.newTestSuiteContext();
		
		// create node dispatcher
		dispatcher = new TRCNodeDispatcher(context);
		 		
		// create node assembler
		assembler = new TRCNodeAssembler(dispatcher);

		// initialize SAX parser
		SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
		saxParserFactory.setNamespaceAware(true);
		saxParserFactory.setValidating(false);
		
		try {
			saxParserFactory.setFeature("http://xml.org/sax/features/validation", false);
			saxParserFactory.setFeature("http://xml.org/sax/features/namespaces", true);
			saxParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
			SAXParser saxParser = saxParserFactory.newSAXParser();
					
			xmlReader = saxParser.getXMLReader();
		}
		catch ( SAXException exc )
		{
			throw new TestgenException(TestgenHttpPlugin.
					getResourceString("E_SAX_DRIVER_FAILURE"), exc);
		}
		catch ( ParserConfigurationException exc )
		{
			throw new TestgenException(TestgenHttpPlugin.
					getResourceString("E_SAX_DRIVER_FAILURE"), exc);
		}
		
		if (xmlReader == null)
			throw new TestgenException(TestgenHttpPlugin.
				getResourceString("E_SAX_DRIVER_FAILURE"));

		xmlReader.setContentHandler(handler);
		xmlReader.setErrorHandler(handler);

		// derive inputSource	
		InputStream inputStream = null;
		try {
			inputStream = recFile.getContents();
		}
		catch (CoreException e) {
			e.printStackTrace();
		}
		InputSource inputSource = new InputSource(inputStream);

		// call SAX to parse inputSource
		try {
			xmlReader.parse(inputSource);
		}
		catch (IOException e) {
			throw new TestgenException(TestgenHttpPlugin.
				getResourceString("E_SAX_IOEXCEPTION"), e);
		}
		catch (SAXException e) {
			throw new TestgenException(TestgenHttpPlugin.
				getResourceString("E_SAX_SAXEXCEPTION"), e);
		}
	
		context.finish();
		
		return true;
	}
	
	//
	// begin SAX callbacks
	//
	
	public void startElement (String uri, String localName,
					String qName, Attributes attributes)
	{
		updater.progress(TestgenHttpPlugin.getResourceString("I_PROCESSING") +
			" " + qName);

		TRCElement element = new TRCElement(attributes.getLength());
		element.setName(qName);
		for (int i = 0; i < attributes.getLength(); ++i)
			element.addAttribute(attributes.getQName(i),
				attributes.getValue(i));
		list.addLast(element);

		try {
			assembler.newElement(element, list.size() /* depth */, qName);
		}
		catch (TestgenException e) {
			e.printStackTrace();
		}
	}
		
	public void endElement (String uri, String localName,
					String qName)
	{
		TRCElement element = (TRCElement)list.removeLast();
		try {
			assembler.completeElement(element, list.size() + 1 /* depth */,
				qName);
		}
		catch (TestgenException e) {
			e.printStackTrace();
		}
	}
	
	public void characters (char [] ch, int start, int length)
	{
		TRCElement element = (TRCElement)list.getLast();
		element.setContent(new String(ch, start, length));
	}
	
//	public void startDocument ()
//	{
//	}
	
//	public void endDocument ()
//	{
//	}
	
//	public void ignorableWhitespace (char [] ch, int start, int length)
//	{
//	}

//	public void warning (SAXParseException e)
//	{
//		System.err.println(e.getMessage());
//	}
	
//	public void error (SAXParseException e)
//	{
//		System.err.println(e.getMessage());
//	}
	
//	public void fatalError (SAXParseException e)
//	{
//		System.err.println(e.getMessage());
//	}

	//
	// end SAX callbacks
	//
	
}
