/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.editors;

import java.util.ArrayList;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.models.internal.sdb.*;
import org.eclipse.hyades.models.internal.sdb.impl.*;
import org.eclipse.hyades.sdb.internal.SDbPlugin;
import org.eclipse.hyades.sdb.internal.help.ContextIds;
import org.eclipse.hyades.sdb.internal.util.GridUtil;
import org.eclipse.hyades.sdb.internal.util.RASWidgetFactory;

public class SymptomDetails extends Composite implements IDetails, Listener {

	Text txtSymptom;
	Text lstMatch;
	private SDBFactoryImpl objFactory = null;
	private SymptomDBEditor editor;
	private SDBSymptom currentSel = null;
	private boolean isDisplaying = false;

	public SymptomDetails(
		RASWidgetFactory factory,
		Composite composite,
		int style) {

		super(composite, style);

		GridLayout descLayout = new GridLayout();
		descLayout.numColumns = 1;
		this.setLayout(descLayout);
		this.setLayoutData(GridUtil.createFill());

		Label lblSymptom =
			factory.createLabel(
				this,
				SDbPlugin.getResourceString("STR_SYMPTOM_LABEL"),
				SWT.NONE);
		txtSymptom = factory.createText(this, "", RASWidgetFactory.BORDER_STYLE);
		txtSymptom.setLayoutData(GridUtil.createHorizontalFill());

		factory.createCompositeSeparator(this);

		Label lblMatch =
			factory.createLabel(
				this,
				SDbPlugin.getResourceString("STR_MATCH_SYMPTOM_LABEL"),
				SWT.NONE);
		GridData lblMatchLayout = new GridData(GridData.FILL_HORIZONTAL);
		lblMatch.setLayoutData(lblMatchLayout);

		lstMatch =
			factory.createText(
				this,
				"",
				RASWidgetFactory.BORDER_STYLE | SWT.V_SCROLL | SWT.H_SCROLL | SWT.MULTI);
		GridData lstMatchLayout = new GridData(GridData.FILL_BOTH);
		lstMatchLayout.heightHint = 45;
		lstMatchLayout.verticalSpan = 3;
		lstMatch.setLayoutData(lstMatchLayout);

		WorkbenchHelp.setHelp(txtSymptom, ContextIds.SYMDB_EDITOR_SYMPTOM);
		WorkbenchHelp.setHelp(lstMatch, ContextIds.SYMDB_EDITOR_SYMPTOM_DESCRIPTION);

		// add listeners - don't change the order in which the listeners are added
		// because of team support issues modify listeners should always be the last one added
		txtSymptom.addListener(SWT.Modify, this);
		lstMatch.addListener(SWT.Modify, this);
		
	}
	public void init(SymptomDBEditor editor) {
		this.editor = editor;
		objFactory = SDbPlugin.getDefault().getSDBFactory();
	}
	public void display(EObject object) {
		isDisplaying = true;
		currentSel = (SDBSymptom) object;
		txtSymptom.setText(currentSel.getDescription());
		lstMatch.setText(getMatchPattern());
		isDisplaying = false;
	}
	public void setFocusToTextBox() {
		txtSymptom.setFocus();
		txtSymptom.setSelection(0, txtSymptom.getText().length());
	}
	public void handleEvent(Event e) {
		Widget source = e.widget;

		if (source == txtSymptom || source == lstMatch) {
			boolean status  = false;
			if(source == txtSymptom && isDisplaying == false){
				status = editor.validateState(txtSymptom, this, currentSel.getDescription());
			}
			if(source == lstMatch && isDisplaying == false){
				status = editor.validateState(lstMatch, this, getMatchPattern());
			}
			
			if (currentSel != null && isDisplaying == false && status==true) {
				editor.updateUIDirtyStatus(true);
				editor.updateModelDirtyStatus(true);
			}
		}
	}
	/*protected boolean validate(){
	
	
		if(txtSymptom.getText().length()==0){
	    	MessageDialog.openError(Display.getCurrent().getActiveShell(),
	                                       "Invalid symptom description",
	                                       "The symptom description must have at least one character");
	        return false;                               
		}
		
		
		TRCRuntime parent = (TRCRuntime)editor.detailsPage.getTreeRoot();
		
		for(int i=0;i<parent.getSymptoms().size();i++){
			TRCSymptom current = (TRCSymptom)parent.getSymptoms().get(i);
			if(current.getDescription().equals(txtSymptom.getText())){
		        MessageDialog.openError(Display.getCurrent().getActiveShell(),
		                                       "Duplicate symptom",
		                                       "The database already contains this symptom");
		        return false;
		    }
		}
	
		return true;
		                                      		
	}*/
	private String getMatchPattern(){
		String pattern = "";
		EList lstPattern = currentSel.getPatterns();
		String nl = System.getProperties().getProperty("line.separator");
		int size = lstPattern.size();
		for (int i = 0; i < size; i++) {
			pattern =
				pattern
					+ (String) ((SDBMatchPattern) lstPattern.get(i)).getValue()
					+ (i == size - 1 ? "" : nl);
		}
		return pattern;
	}
	
	private ArrayList getPatternLines() {
		ArrayList lines = new ArrayList();
		String text = lstMatch.getText();
		String nl = System.getProperties().getProperty("line.separator");
		int i = 0;
		int j = 0;

		while (i <= text.length()) {

			if ((j = text.indexOf(nl, i)) > -1) {
				lines.add(text.substring(i, j));
			} else {
				lines.add(text.substring(i));
				break;
			}
			i = j + nl.length();
		}
		return lines;
	}
	public boolean updateCurrentSelection(EObject sel) {
		/*if(!validate())
			return false;*/

		currentSel = (SDBSymptom) sel;
		currentSel.setDescription(txtSymptom.getText());

		EList lstPattern = currentSel.getPatterns();
		int l = lstPattern.size();
		ArrayList lines = getPatternLines();
		int s = lines.size();

		if ((s == 1) && ((String) lines.get(0)).equals("")) {
			currentSel.getPatterns().clear();
			return true;
		}

		if (l > s) {
			for (int i = 0; i < s; i++) {
				((SDBMatchPattern) lstPattern.get(i)).setValue((String) lines.get(i));
			}
			ArrayList delPattern = new ArrayList();
			for (int i = s; i < l; i++)
				delPattern.add(lstPattern.get(i));
			currentSel.getPatterns().removeAll(delPattern);
		} else {
			for (int i = 0; i < l; i++) {
				((SDBMatchPattern) lstPattern.get(i)).setValue((String) lines.get(i));
			}
			if (l < s) {
				for (int i = l; i < s; i++) {
					SDBMatchPattern match = objFactory.createSDBMatchPattern();
					match.setValue((String) lines.get(i));
					currentSel.getPatterns().add(match);
				}

			}
		}
		return true;
	}
}
