/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.util;

import java.util.List;

public interface ResourceStateInputProvider {	
	/**
	 * Return true if any of the controlled resources or files has been
	 * modified.
	 * @return boolean
	 */
	boolean isDirty();

	/**
	 * Return a <code>List</code> of IFiles that are not MOF Resources that are
	 * also being modified.
	 * @return List
	 */
	List getNonResourceFiles();
}

