/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sdb.internal.util;

import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.internal.sdb.*;

/**
 * This class offers search capability through the Symptom Database
 */
public class SymptomDBTextSearch {

	private SDBRuntime root;
	private Object[] start =null;
	private int[] startIndex = null;
	private int[] index = null;

	/**
	 * Constructor for SymptomDBTextSearch.
	 */
	public SymptomDBTextSearch() {
		super();
	}

	public void initialize(SDBRuntime root, Object[] start){
		this.root = root;
		this.start = start;
	    startIndex = new int[]{-1,-1,-1,-1};
	    index = new int[]{-1,-1,-1,-1}; 	
		startIndex = lookForStartNode(start);
	}	
	/**
	 * 
	 */
	public Object[] search(String pattern, int direction, boolean bCaseSensitive){
					
		if(startIndex==null){
	        setStartIndex(-1,-1,-1,-1);	
			startIndex = lookForStartNode(start);
		}
		
		if(startIndex[1]==-1 && direction>0){
			
			setIndex(0,0,0,0);
			return searchDown(pattern, bCaseSensitive);
		}
		
		if(startIndex[1]==-1 && direction<0){
			startIndex[0] = -1;
			setIndex(startIndex[0], startIndex[1], startIndex[2], startIndex[3]);
			return searchUp(pattern, bCaseSensitive);
		}
		
		if(startIndex[2]==-1 && direction>0){
			setIndex(0,startIndex[1],0,0);
			return searchDown(pattern, bCaseSensitive);
		}
		
		if(startIndex[2]==-1 && direction<0){
			if(startIndex[1]-1>=0){
				// search has to begin with the last solution and last directive of the previous symptom
				setIndex(0,startIndex[1]-1,-11,-11);
				return searchUp(pattern, bCaseSensitive);
			}
			else{
				setIndex(0,-1,-1,-1);
				return searchUp(pattern, bCaseSensitive);
			}
		}

		if(startIndex[3]==-1 && direction>0){
			setIndex(0,startIndex[1], startIndex[2],0);
			return searchDown(pattern, bCaseSensitive);
		}
				
		if(startIndex[3]==-1 && direction<0){
			if(startIndex[2] -1 >=0){
				setIndex(0,startIndex[1],startIndex[2] -1,-11);
				// search has to begin with the last last directive of the previous solution
				return searchUp(pattern, bCaseSensitive);
			}			
			else{
				setIndex(0,startIndex[1],startIndex[2] -1,-1);
				return searchUp(pattern, bCaseSensitive);
			}
		}

        if(direction>0){
        	setIndex(0,startIndex[1],startIndex[2],startIndex[3]);
        	return searchDown(pattern, bCaseSensitive);
        }
        else{
        	setIndex(0,startIndex[1],startIndex[2],startIndex[3]-1);
        	return searchUp(pattern, bCaseSensitive);
        }
        	                        
	}
	

	private int[] lookForStartNode(Object[] start){
				
		if(start[0]==null){
			startIndex[0] = -1;
			return startIndex;					
		}

		startIndex[0]= 0;
		if(start[1]==null){
			return startIndex;		
		}

		EList symptoms = root.getSymptoms();		
		startIndex[1] = symptoms.indexOf((SDBSymptom)start[1]);

		if(start[2]==null){
			startIndex[2] = -1;
			return startIndex;
		}

		SDBSymptom symptom = (SDBSymptom) start[1];
		EList solutions = symptom.getSolutions();
		
		startIndex[2] = solutions.indexOf((SDBSolution)start[2]);
		
		if(start[3]==null){
			startIndex[3] = -1;
			return startIndex;		
		}
						
		SDBSolution sol = (SDBSolution) start[2];
		EList directives = sol.getDirectives();
		
		startIndex[3] = directives.indexOf((SDBDirective)start[3]);
		return startIndex;
	}
	
	private boolean searchPatternIn(String pattern, String target, boolean bCaseSensitive){
		if(bCaseSensitive){	
			if(target.indexOf(pattern) < 0){
				return false;
			}
		}
		else{
			target = target.toLowerCase();
			pattern = pattern.toLowerCase();
			if(target.indexOf(pattern) < 0)
				return false;
			
		}
		return true;
	}

   private Object[] searchDown(String pattern, boolean bCaseSensitive){

			if(startIndex[0] < 0){
				if(searchPatternIn(pattern, root.getDescription() + root.getLocalExternalFileLocation() + root.getName() + root.getSymptomUrl(),bCaseSensitive)){
					setStartIndex(0,-1,-1,-1);
					setStartObject(root, null, null, null);
					return start;
				}
			}

			EList symptoms = root.getSymptoms();
			int k=index[2];
			int l=index[3];
			for(int i=index[1];i>=0 && i<symptoms.size();i++){
				SDBSymptom symptom = (SDBSymptom)symptoms.get(i);
				if(i!=startIndex[1]){
					if(searchPatternIn(pattern, symptom.getDescription(), bCaseSensitive)){
						setStartIndex(0,i,-1,-1);
						setStartObject(root,symptom,null,null);
						return start;
					}
					
					EList patterns = symptom.getPatterns();				
					for(int j=0;j<patterns.size();j++){
						SDBMatchPattern match = (SDBMatchPattern)patterns.get(j);
						if(searchPatternIn(pattern, match.getValue(), bCaseSensitive)){
							setStartIndex(0,i,-1,-1);
							setStartObject(root,symptom,null,null);
							return start;					
						}
					}
				}
				EList solutions = symptom.getSolutions();				
				
				for(;k>=0 && k<solutions.size();k++){
					
					SDBSolution sol = (SDBSolution)solutions.get(k);
					if(!(i==startIndex[1] && k==startIndex[2])){
						if(searchPatternIn(pattern, sol.getDescription(), bCaseSensitive)){
							setStartIndex(0,i,k,-1);
							setStartObject(root,symptom,sol,null);						   
							return start;					
						}
					}	
					
					EList directives = sol.getDirectives();
										
					for(;l>=0 && l<directives.size();l++){
						SDBDirective dir = (SDBDirective)directives.get(l);
						if(!(i==startIndex[1] && k==startIndex[2] && l==startIndex[3])){
							if(searchPatternIn(pattern, dir.getDescription(), bCaseSensitive) || searchPatternIn(pattern, dir.getDirectiveString(), bCaseSensitive)){
								setStartIndex(0,i,k,l);
								setStartObject(root,symptom,sol,dir);
								return start;					
							}
						}
					}
					l = 0;
					
				}
				k = 0;
			}

			setStartObject(null,null,null,null);
			return start;

   }

   private Object[] searchUp(String pattern, boolean bCaseSensitive){

			EList symptoms = root.getSymptoms();
			
			for(int i=index[1];i>=0 && i<symptoms.size();i--){
				SDBSymptom symptom = (SDBSymptom)symptoms.get(i);

				EList solutions = symptom.getSolutions();				
				int k=solutions.size()-1;
				
				// a solution is the selected node so begin the new find starting from that element
				// or 
				if(i==index[1] && index[2]>=-1)
					k = index[2];
									
				for(;k>=0 && k<solutions.size();k--){
					
					SDBSolution sol = (SDBSolution)solutions.get(k);
					
					EList directives = sol.getDirectives();
					int l=directives.size()-1;
					if(i==index[1] && k==index[2] && index[3]>=-1)
						l = index[3];
										
					for(;l>=0 && l<directives.size();l--){
						SDBDirective dir = (SDBDirective)directives.get(l);
						if(!(i==startIndex[1] && k==startIndex[2] && l==startIndex[3])){

							if(searchPatternIn(pattern, dir.getDescription(), bCaseSensitive) || searchPatternIn(pattern, dir.getDirectiveString(), bCaseSensitive)){
								setStartIndex(0,i,k,l);
								setStartObject(root,symptom,sol,dir);
								return start;					
							}
						}
					}
					

					if(searchPatternIn(pattern, sol.getDescription(), bCaseSensitive)){
						setStartIndex(0,i,k,-1);
						setStartObject(root,symptom,sol,null);					    
						return start;
					}

										
				}
				
				if(searchPatternIn(pattern, symptom.getDescription(), bCaseSensitive)){
					setStartIndex(0,i,-1,-1);
					setStartObject(root,symptom,null,null);
					return start;
				}
					
				EList patterns = symptom.getPatterns();				
				for(int j=0;j<patterns.size();j++){
					SDBMatchPattern match = (SDBMatchPattern)patterns.get(j);
					if(searchPatternIn(pattern, match.getValue(), bCaseSensitive)){
						setStartIndex(0,i,-1,-1);
						setStartObject(root,symptom,null,null);
						return start;					
					}
				}
					
			}

			if(startIndex[0] > -1){
				if(searchPatternIn(pattern, root.getDescription() + root.getLocalExternalFileLocation() + root.getName() + root.getSymptomUrl(),bCaseSensitive)){
					setStartIndex(0,-1,-1,-1);
					setStartObject(root, null, null, null);
					return start;
				}
			}
   
   		 setStartObject(null,null,null,null);
   		 return start;
   }

	
	private void setStartIndex(int i0, int i1, int i2, int i3){
			
		startIndex[0] = i0;
		startIndex[1] = i1;
		startIndex[2] = i2;
		startIndex[3] = i3;

	}
	
	private void setIndex(int i0, int i1, int i2, int i3){
			
		index[0] = i0;
		index[1] = i1;
		index[2] = i2;
		index[3] = i3;

	}
	
	private void setStartObject(Object s0, Object s1, Object s2, Object s3){

		start[0] = s0;
		start[1] = s1;
		start[2] = s2;
		start[3] = s3;
	
	}
}
