/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import org.eclipse.hyades.loaders.hierarchy.Constants;
import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.LookupServiceExtensions;
import org.eclipse.hyades.models.trace.TRCArrayClass;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TraceFactory;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCFullTraceObjectImpl;
import org.eclipse.hyades.models.trace.impl.TRCHeapObjectImpl;
/**
 * @author slavescu
 *
 */
public class XMLclassDefLoader extends TraceXMLFragmentLoader {
    //~ Static fields/initializers -----------------------------------------------------------------

    protected static final String NUM_STATIC_FIELDS = "numStaticFields";
    protected static final String NUM_METHODS = "numMethods";
    protected static final String NUM_INTERFACES = "numInterfaces";
    protected static final String NUM_INSTANCES_FIELDS = "numInstanceFields";
    protected static final String ACCESS = "access";
    protected static final String SOURCE_NAME = "sourceName";
    protected static final String CLASS_ID = "classId";

    //~ Instance fields ----------------------------------------------------------------------------

    protected String access;
    protected String name;
    protected String sourceName;
    protected int classId;
    protected int numInstanceFields;
    protected int numInterfaces;
    protected int numMethods;
    protected int numStaticFields;
    private boolean java_lang_class;

    //~ Methods ------------------------------------------------------------------------------------

    public void addAttribute(String name, String value) {
        switch (LoadersUtils.getHashCode(name)) {
        case TraceConstants.CLASS_ID_int:
            classId = Integer.parseInt(value);

            break;

        case TraceConstants.NAME_int:
            this.name = value;

            break;

        case TraceConstants.SOURCE_NAME_int:
            sourceName = value;

            break;

        case TraceConstants.ACCESS_int:
            access = value;

            break;

        case TraceConstants.NUM_INSTANCES_FIELDS_int:
            numInstanceFields = Integer.parseInt(value);

            break;

        case TraceConstants.NUM_INTERFACES_int:
            numInterfaces = Integer.parseInt(value);

            break;

        case TraceConstants.NUM_METHODS_int:
            numMethods = Integer.parseInt(value);

            break;

        case TraceConstants.NUM_STATIC_FIELDS_int:
            numStaticFields = Integer.parseInt(value);

            break;

        default:
            super.addAttribute(name, value);

            break;
        }
    }

    public void addYourselfInContext() {
        if (sourceName == null) {
            sourceName = UNKNOWN;
        }

        if (name == null) {
            name = UNKNOWN;
        }

        createTRCType();
    }

    public void initialize(HierarchyContext context, String name) {
        super.initialize(context, name);
        classId = 0;
        sourceName = null;
        name = null;
        access = null;
        numStaticFields = 0;
        numMethods = 0;
        numInstanceFields = 0;
    }

    protected void processEF(int step) {
        super.processEF(step);
        processES(step);
    }

    /**
     *
     */
    protected void processES(int step) {
        super.processES(step);

        switch (step) {
        case ProcessSteps.GET_CLASS_OBJECT:

            /* Look for the class object in the model if we have been given an object Id*/
            if (objIdRef != 0) {
                theObject = getClassObjectByIdRef(objIdRef, TRCFullTraceObjectImpl.class);
            } else {
                theObject = getClassObjectByIdRef(-classId, TRCFullTraceObjectImpl.class);
            }

            if (theObject == null) {
                // now add a class object
                theObject = TraceFactory.eINSTANCE.createTRCFullTraceObject();

                if (objIdRef == 0) {
                    theObject.setId(-classId);
                } else {
                    theObject.setId(objIdRef);
                    updateTRCFullTraceObjectFromVOI(objIdRef);
                }

                theObject.setProcess(theProcess);
            }

			theObject.setSize(theClass.getSize());
            theClass.getClassObjects().add(theObject);

            //adds the class object to the Class class
            TraceUtils.addClassObjectToClassClass(context, theProcess, theObject);

            break;

        default:
            break;
        }
    }

    /**
     *
     */
    protected void processHF(int step) {
        super.processHF(step);
        processHS(step);
    }

    protected void processHS(int step) {
        super.processHS(step);

        switch (step) {
        case ProcessSteps.GET_CLASS_OBJECT:
            theObject = null;
        	Class clazz = (TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS) ? TRCFullHeapObjectImpl.class : TRCHeapObjectImpl.class);
            /* Look for the class object in the model if we have been given an object Id*/
            if (objIdRef != 0) {
                theObject = getClassObjectByIdRef(objIdRef, clazz);
            } else {
                theObject = getClassObjectByIdRef(-classId, clazz);
            }

            if (theObject == null) {
                // now add a class object
            	if(TraceUtils.isBooleanOptionEnabled(context,Constants.MULTIPLE_HEAP_DUMPS))
            		theObject = TraceFactory.eINSTANCE.createTRCFullHeapObject();
            	else
            		theObject = TraceFactory.eINSTANCE.createTRCHeapObject();
                if (objIdRef == 0) {
                    theObject.setId(-classId);
                } else {
                    theObject.setId(objIdRef);
                }

                theObject.setProcess(theProcess);
            }
            
            theClass.getClassObjects().add(theObject);

            //adds the class object to the Class class
            TraceUtils.addClassObjectToClassClass(context, theProcess, theObject);

            break;

        default:
            break;
        }
    }

    protected void updateTRCFullTraceObjectFromVOI(long oId) {
        VirtualObjectInfo objectInfo = (VirtualObjectInfo) LookupServiceExtensions.getInstance().locate(context, VirtualObjectInfo.class, LoadersUtils.getLookUpKey(oId));

        if (objectInfo != null) {
            TRCFullTraceObject object = (TRCFullTraceObject) theObject;

            object.setCreateTime(objectInfo.createTime);
            object.setSize(objectInfo.size);
			TraceUtils.removeVirtualObject(context, objIdRef);
        }
    }

    private void createTRCType() {
        theProcess = getProcess();
        java_lang_class = false;

        int hash = LoadersUtils.getHashCode(name);

        if ((hash == TraceConstants.CLASS_CLASS1_int) || (hash == TraceConstants.CLASS_CLASS2_int)) //if class Class
         {
            // last update wins - update the class Class info
            theClass = theProcess.getClassClass();

            if (theClass != null) {
                if (theClass.getId() != classId) {
                    LookupServiceExtensions.getInstance().deregister(context, TRCClassImpl.class, LoadersUtils.getLookUpKey(theClass.getId()));
                    theClass.setId(classId);
                    LookupServiceExtensions.getInstance().register(context, theClass);
                }
            } else {
                theClass = (TRCClass) LookupServiceExtensions.getInstance().locate(context, TRCClassImpl.class, LoadersUtils.getLookUpKey(classId));
                java_lang_class = true;
            }
        } else {
            theClass = (TRCClass) LookupServiceExtensions.getInstance().locate(context, TRCClassImpl.class, LoadersUtils.getLookUpKey(classId));
        }

        if (theClass == null) {
            if (name.charAt(0) == '[') {
                theClass = TraceFactory.eINSTANCE.createTRCArrayClass();

                TRCClass elementClass = findClass(theProcess, name.substring(1));

                if (elementClass != null) {
                    ((TRCArrayClass) theClass).setElementType(elementClass);
                }
            } else {
                theClass = TraceFactory.eINSTANCE.createTRCClass();
            }
        }

        // last update wins
        theClass.setName(TraceUtils.className(name));
        theClass.setId(classId);
        theClass.setLoadTime(createDeltaTime());

        TraceUtils.addClassToPackage(context, theClass, name, theProcess);

        TraceUtils.setSourceInfo(context, theProcess, theClass, sourceName);

        if ((theProcess.getClassClass() == null) && java_lang_class) // if class Class not set
         {
            theProcess.setClassClass(theClass);

            //	else do nothing because a fake one will be created automaticaly
        }

        theThread = getThreadByIdRef(theProcess);

        dispatchProcessMode(ProcessSteps.GET_CLASS_OBJECT);

        theClass.setLoadedBy(theThread);
    }

    private TRCClass findClass(TRCProcess p, String name) {
        return null;
    }
}
