/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.models.trace.TRCClassLoader;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Class Loader</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassLoaderImpl#getProcess <em>Process</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCClassLoaderImpl#getClassLoaderInstance <em>Class Loader Instance</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCClassLoaderImpl extends EObjectImpl implements TRCClassLoader {
	/**
	 * The cached value of the '{@link #getClassLoaderInstance() <em>Class Loader Instance</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClassLoaderInstance()
	 * @generated
	 * @ordered
	 */
	protected TRCObject classLoaderInstance = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCClassLoaderImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCClassLoader();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcess getProcess() {
		if (eContainerFeatureID != TracePackage.TRC_CLASS_LOADER__PROCESS) return null;
		return (TRCProcess)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setProcess(TRCProcess newProcess) {
		if (newProcess != eContainer || (eContainerFeatureID != TracePackage.TRC_CLASS_LOADER__PROCESS && newProcess != null)) {
			if (EcoreUtil.isAncestor(this, newProcess))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newProcess != null)
				msgs = ((InternalEObject)newProcess).eInverseAdd(this, TracePackage.TRC_PROCESS__CLASS_LOADERS, TRCProcess.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newProcess, TracePackage.TRC_CLASS_LOADER__PROCESS, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS_LOADER__PROCESS, newProcess, newProcess));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject getClassLoaderInstance() {
		if (classLoaderInstance != null && classLoaderInstance.eIsProxy()) {
			TRCObject oldClassLoaderInstance = classLoaderInstance;
			classLoaderInstance = (TRCObject)eResolveProxy((InternalEObject)classLoaderInstance);
			if (classLoaderInstance != oldClassLoaderInstance) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TracePackage.TRC_CLASS_LOADER__CLASS_LOADER_INSTANCE, oldClassLoaderInstance, classLoaderInstance));
			}
		}
		return classLoaderInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCObject basicGetClassLoaderInstance() {
		return classLoaderInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setClassLoaderInstance(TRCObject newClassLoaderInstance) {
		TRCObject oldClassLoaderInstance = classLoaderInstance;
		classLoaderInstance = newClassLoaderInstance;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_CLASS_LOADER__CLASS_LOADER_INSTANCE, oldClassLoaderInstance, classLoaderInstance));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_CLASS_LOADER__PROCESS:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_CLASS_LOADER__PROCESS, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_CLASS_LOADER__PROCESS:
					return eBasicSetContainer(null, TracePackage.TRC_CLASS_LOADER__PROCESS, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_CLASS_LOADER__PROCESS:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_PROCESS__CLASS_LOADERS, TRCProcess.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_CLASS_LOADER__PROCESS:
				return getProcess();
			case TracePackage.TRC_CLASS_LOADER__CLASS_LOADER_INSTANCE:
				if (resolve) return getClassLoaderInstance();
				return basicGetClassLoaderInstance();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_CLASS_LOADER__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_CLASS_LOADER__CLASS_LOADER_INSTANCE:
				setClassLoaderInstance((TRCObject)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_CLASS_LOADER__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_CLASS_LOADER__CLASS_LOADER_INSTANCE:
				setClassLoaderInstance((TRCObject)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_CLASS_LOADER__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_CLASS_LOADER__CLASS_LOADER_INSTANCE:
				return classLoaderInstance != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //TRCClassLoaderImpl
