/**********************************************************************
 * Copyright (c) 2003, 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.trace.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullHeapObject;
import org.eclipse.hyades.models.trace.TRCProcess;
import org.eclipse.hyades.models.trace.TracePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TRC Full Heap Object</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.trace.impl.TRCFullHeapObjectImpl#getHeapDumpFirstSeen <em>Heap Dump First Seen</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TRCFullHeapObjectImpl extends TRCHeapObjectImpl implements TRCFullHeapObject {
	/**
	 * The default value of the '{@link #getHeapDumpFirstSeen() <em>Heap Dump First Seen</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHeapDumpFirstSeen()
	 * @generated
	 * @ordered
	 */
	protected static final short HEAP_DUMP_FIRST_SEEN_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getHeapDumpFirstSeen() <em>Heap Dump First Seen</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHeapDumpFirstSeen()
	 * @generated
	 * @ordered
	 */
	protected short heapDumpFirstSeen = HEAP_DUMP_FIRST_SEEN_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TRCFullHeapObjectImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return TracePackage.eINSTANCE.getTRCFullHeapObject();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public short getHeapDumpFirstSeen() {
		return heapDumpFirstSeen;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setHeapDumpFirstSeen(short newHeapDumpFirstSeen) {
		short oldHeapDumpFirstSeen = heapDumpFirstSeen;
		heapDumpFirstSeen = newHeapDumpFirstSeen;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TracePackage.TRC_FULL_HEAP_OBJECT__HEAP_DUMP_FIRST_SEEN, oldHeapDumpFirstSeen, heapDumpFirstSeen));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_FULL_HEAP_OBJECT__IS_A:
					if (isA != null)
						msgs = ((InternalEObject)isA).eInverseRemove(this, TracePackage.TRC_CLASS__OBJECTS, TRCClass.class, msgs);
					return basicSetIsA((TRCClass)otherEnd, msgs);
				case TracePackage.TRC_FULL_HEAP_OBJECT__PROCESS:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, TracePackage.TRC_FULL_HEAP_OBJECT__PROCESS, msgs);
				case TracePackage.TRC_FULL_HEAP_OBJECT__REF_OWNER:
					return ((InternalEList)getRefOwner()).basicAdd(otherEnd, msgs);
				case TracePackage.TRC_FULL_HEAP_OBJECT__REF_TARGET:
					return ((InternalEList)getRefTarget()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case TracePackage.TRC_FULL_HEAP_OBJECT__IS_A:
					return basicSetIsA(null, msgs);
				case TracePackage.TRC_FULL_HEAP_OBJECT__PROCESS:
					return eBasicSetContainer(null, TracePackage.TRC_FULL_HEAP_OBJECT__PROCESS, msgs);
				case TracePackage.TRC_FULL_HEAP_OBJECT__REF_OWNER:
					return ((InternalEList)getRefOwner()).basicRemove(otherEnd, msgs);
				case TracePackage.TRC_FULL_HEAP_OBJECT__REF_TARGET:
					return ((InternalEList)getRefTarget()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case TracePackage.TRC_FULL_HEAP_OBJECT__PROCESS:
					return ((InternalEObject)eContainer).eInverseRemove(this, TracePackage.TRC_PROCESS__OBJECTS, TRCProcess.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_FULL_HEAP_OBJECT__ID:
				return new Long(getId());
			case TracePackage.TRC_FULL_HEAP_OBJECT__SIZE:
				return new Integer(getSize());
			case TracePackage.TRC_FULL_HEAP_OBJECT__IS_A:
				if (resolve) return getIsA();
				return basicGetIsA();
			case TracePackage.TRC_FULL_HEAP_OBJECT__PROCESS:
				return getProcess();
			case TracePackage.TRC_FULL_HEAP_OBJECT__REF_OWNER:
				return getRefOwner();
			case TracePackage.TRC_FULL_HEAP_OBJECT__REF_TARGET:
				return getRefTarget();
			case TracePackage.TRC_FULL_HEAP_OBJECT__HEAP_DUMP_FIRST_SEEN:
				return new Short(getHeapDumpFirstSeen());
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_FULL_HEAP_OBJECT__ID:
				setId(((Long)newValue).longValue());
				return;
			case TracePackage.TRC_FULL_HEAP_OBJECT__SIZE:
				setSize(((Integer)newValue).intValue());
				return;
			case TracePackage.TRC_FULL_HEAP_OBJECT__IS_A:
				setIsA((TRCClass)newValue);
				return;
			case TracePackage.TRC_FULL_HEAP_OBJECT__PROCESS:
				setProcess((TRCProcess)newValue);
				return;
			case TracePackage.TRC_FULL_HEAP_OBJECT__REF_OWNER:
				getRefOwner().clear();
				getRefOwner().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_FULL_HEAP_OBJECT__REF_TARGET:
				getRefTarget().clear();
				getRefTarget().addAll((Collection)newValue);
				return;
			case TracePackage.TRC_FULL_HEAP_OBJECT__HEAP_DUMP_FIRST_SEEN:
				setHeapDumpFirstSeen(((Short)newValue).shortValue());
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_FULL_HEAP_OBJECT__ID:
				setId(ID_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_HEAP_OBJECT__SIZE:
				setSize(SIZE_EDEFAULT);
				return;
			case TracePackage.TRC_FULL_HEAP_OBJECT__IS_A:
				setIsA((TRCClass)null);
				return;
			case TracePackage.TRC_FULL_HEAP_OBJECT__PROCESS:
				setProcess((TRCProcess)null);
				return;
			case TracePackage.TRC_FULL_HEAP_OBJECT__REF_OWNER:
				getRefOwner().clear();
				return;
			case TracePackage.TRC_FULL_HEAP_OBJECT__REF_TARGET:
				getRefTarget().clear();
				return;
			case TracePackage.TRC_FULL_HEAP_OBJECT__HEAP_DUMP_FIRST_SEEN:
				setHeapDumpFirstSeen(HEAP_DUMP_FIRST_SEEN_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case TracePackage.TRC_FULL_HEAP_OBJECT__ID:
				return id != ID_EDEFAULT;
			case TracePackage.TRC_FULL_HEAP_OBJECT__SIZE:
				return size != SIZE_EDEFAULT;
			case TracePackage.TRC_FULL_HEAP_OBJECT__IS_A:
				return isA != null;
			case TracePackage.TRC_FULL_HEAP_OBJECT__PROCESS:
				return getProcess() != null;
			case TracePackage.TRC_FULL_HEAP_OBJECT__REF_OWNER:
				return refOwner != null && !refOwner.isEmpty();
			case TracePackage.TRC_FULL_HEAP_OBJECT__REF_TARGET:
				return refTarget != null && !refTarget.isEmpty();
			case TracePackage.TRC_FULL_HEAP_OBJECT__HEAP_DUMP_FIRST_SEEN:
				return heapDumpFirstSeen != HEAP_DUMP_FIRST_SEEN_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (heapDumpFirstSeen: ");
		result.append(heapDumpFirstSeen);
		result.append(')');
		return result.toString();
	}

} //TRCFullHeapObjectImpl
