/**********************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM Corporation - initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.execution.recorder.http.ui.wizards;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.hyades.execution.recorder.http.HttpRecorderPlugin;
import org.eclipse.hyades.internal.execution.recorder.ui.RecorderUIUtility;
import org.eclipse.hyades.internal.execution.recorder.ui.wizards.IRecorderWizardPage;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.internal.WorkbenchMessages;

/**
 * @author jnevicos
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class HttpRecorderNoProjectsPage extends WizardNewProjectCreationPage 
	implements IRecorderWizardPage {

	private Text recFileText;

	public static final String SOURCE_DIR = "src";
	
	private Listener modifyListener = new Listener() {
		public void handleEvent(Event e) {
			if (e.widget == recFileText)
				setPageComplete(validatePage());
		}
	};
	/**
	 * @param pageName
	 */	
	public HttpRecorderNoProjectsPage(String pageName) {
		super(pageName);
		// TODO Auto-generated constructor stub
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) 
	{

		super.createControl(parent);
		setDescription(HttpRecorderPlugin.getResourceString("HttpRecorderNoProjectsPage.DESCRIPTION"));
		setTitle(HttpRecorderPlugin.getResourceString("HttpRecorderNoProjectsPage.TITLE"));
		Composite control = (Composite) getControl();
		
		Composite recFileCanvas = new Composite(control,SWT.NULL);
		recFileCanvas.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		RecorderUIUtility.assignGridLayout(recFileCanvas, 2, false);

		Label label = RecorderUIUtility.createLabel(recFileCanvas, HttpRecorderPlugin.getResourceString("HttpRecorderFileSelectPage.SELECT_RECORDING_FILE_LOCATION_WIZARDPAGE_FILENAME_LABEL"), null);
		
		recFileText = RecorderUIUtility.createEditControl(recFileCanvas, "", null);
		recFileText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		recFileText.addListener(SWT.Modify, modifyListener); 
		
		//add another listener to project name, in order to update location (on next page)
		try {
			Control[] childComposites = control.getChildren();
			for (int i = 0; i < childComposites.length; i++)
			{
				if ( childComposites[i] instanceof Composite)
				{
					Control[] controls = ((Composite)childComposites[i]).getChildren();
					boolean bIsProjName = false;
					Text projText = null;
					for (int j = 0; j < controls.length; j++)
					{
						if (controls[j] instanceof Text)
						{
							projText = (Text) controls[j];
						}
						if (controls[j] instanceof Label)
						{
							if ( ((Label)controls[j]).getText().equals(WorkbenchMessages.getString("WizardNewProjectCreationPage.nameLabel")))
								bIsProjName = true;
						}
					}
					if (bIsProjName && projText != null)
					{
						projText.addListener(SWT.Modify, modifyListener);						
						modifyListener.handleEvent(new Event()); //in case default proj name is set
						break;
					}
						
				}
			}
		
		}
		catch (SWTException e) {}
		
		//set focus to recorder file name if recfile is already populated
		try {
			if (!"".equals(getProjectName()))
				recFileText.setFocus();
		}
		catch(SWTException e) {}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage#getContextHelpID()
	 */
	public String getContextHelpID() {		
		//TODO: Create new help
		return "org.eclipse.hyades.execution.recorder.http.RecordingLocationSelector"; //$NON-NLS-1$
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.internal.execution.testgen.ui.wizards.ITestGenWizardPage#saveSettings()
	 */
	public void saveSettings() {

	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.dialogs.WizardNewProjectCreationPage#validatePage()
	 */
	protected boolean validatePage() {
		boolean b = ( super.validatePage() && isFileNameValid(getRecFile()));
		if (!isFileNameValid(getRecFile()))
		{
			setMessage(HttpRecorderPlugin.getResourceString("HttpRecorderNoProjectsPage.INVALID_REC_FILE"), WARNING);
		}
		return b;
	}

	protected boolean isFileNameValid(String filename)
	{
		//file is later converted to an EMF URI object, so it must be a valid URI
		//thus no URI reserved characters are allowed
		if (filename.length() < 1)
			return false;
		final char[] RESERVED_CHARS = {';', '/' , '?', ':', '@', '&' , '=' , '+', '$' , ',',
				'<', '>', '#', '%', '"', ' ', //delimiters
				'{', '}', '|', '\\', '^', '[', ']', (char)39 /* ' */,  //'unwise' 
				'*'}; //these are allowed in URLs but not in filenames
		
		for (int i = 0; i < RESERVED_CHARS.length; i++)
		{
			if (filename.indexOf(RESERVED_CHARS[i]) > -1)
				return false;
		}
		return true;
		//TODO: DBCS??
/*		java.io.File file = new java.io.File(filename);
		if (file.exists())
			return true;
		try {
			boolean b = file.createNewFile();
			b = b && file.exists();
			if (b)
				file.delete();
			return b;
		}
		catch (IOException ioe) {
			return false;
		}
*/		
	}

	public String getRecFile() {
		if (recFileText == null)
			return "";
		if (recFileText.getText().equals(""))
			return "";
		String recText = recFileText.getText();
		if (!recText.endsWith(".rec"))
			recText += ".rec";
		return recText;
	}
	
	public IProject createJavaProject(IProgressMonitor monitor) throws CoreException
	{
		if (!isPageComplete())
			return null;
			
		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IProject proj = getProjectHandle();
		if (proj == null)
		{
			return null; 
		} 
		if ( !proj.exists() )
			proj.create(monitor);
		proj.open(monitor);
		// Make the test project a java project.
		IProjectDescription projDesc = proj.getDescription();
		String[] natures = projDesc.getNatureIds();
		String[] newNatures = new String[natures.length + 1];
		System.arraycopy(natures, 0, newNatures, 0, natures.length);
		newNatures[natures.length] = JavaCore.NATURE_ID;
		projDesc.setNatureIds(newNatures);
		proj.setDescription(projDesc, IResource.FORCE, null);
		IJavaProject javaProj = JavaCore.create(proj);
		IClasspathEntry[] cp = javaProj.getRawClasspath();
		IClasspathEntry[] newCp = new IClasspathEntry[cp.length+1];		
		System.arraycopy(cp, 0, newCp, 0, cp.length);
		newCp[cp.length] = JavaCore.newContainerEntry(new Path(JavaRuntime.JRE_CONTAINER));
		
		//create src folder
		IPath srcDir = new Path(proj.getFullPath() + "/" + SOURCE_DIR);
		IFolder srcFolder = root.getFolder(srcDir);
		if (!srcFolder.exists())
		{
			srcFolder.create(true, true, monitor);
		}
		
		//update source classpath entry
		boolean bSourceDir = false;
		for (int i = 0; i < newCp.length; i++)
		{
			IClasspathEntry entry = newCp[i];
			if (entry.getEntryKind() == IClasspathEntry.CPE_SOURCE)
			{
				if (!bSourceDir)
				{
					newCp[i] = JavaCore.newSourceEntry(srcDir);
					bSourceDir = true;
				}				
			}
		}
		if (!bSourceDir)
		{
			IClasspathEntry[] tempCp = new IClasspathEntry[newCp.length+1];		
			System.arraycopy(newCp, 0,tempCp, 0, newCp.length);
			tempCp[newCp.length] = JavaCore.newSourceEntry(srcDir);
			newCp = tempCp;
		}
		javaProj.setRawClasspath(newCp, null);
		return proj;		
	}
	
}
