/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.actions;

import org.eclipse.hyades.uml2sd.ui.SDViewerPlugin;
import org.eclipse.hyades.uml2sd.ui.actions.provider.ISDAdvancedPagingProvider;
import org.eclipse.hyades.uml2sd.ui.actions.widgets.PagesDialog;
import org.eclipse.hyades.uml2sd.ui.view.SDView;
import org.eclipse.jface.action.Action;

/**
 * Action delegate for 'Filter' on a message
 */
public class OpenSDPagesDialog extends Action {

	private SDView view;	
	private ISDAdvancedPagingProvider provider;

	/**
	 * @param view_
	 */
	public OpenSDPagesDialog(SDView view_, ISDAdvancedPagingProvider provider_) {
		super(SDViewerPlugin.getResourceString("POPUP_MENU_PAGES"));//$NON-NLS-1$
		setImageDescriptor(SDViewerPlugin.getResourceImage("gotopage.gif")); //$NON-NLS-1$
		setId("org.eclipse.hyades.uml2sd.ui.sdPaging"); //$NON-NLS-1$
		view = view_;
		provider = provider_;
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		if (view == null) {
			return;
		}
		PagesDialog dialog = new PagesDialog(view, provider);
		dialog.open();
	}
	
}
