/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ui.core;

import org.eclipse.hyades.uml2sd.ui.drawings.IColor;
import org.eclipse.hyades.uml2sd.ui.drawings.IGC;
import org.eclipse.hyades.uml2sd.ui.drawings.IImage;
import org.eclipse.hyades.uml2sd.ui.drawings.ISDPreferences;

/**
 * BasicExecutionOccurrence is the UML2 execution occurrence graphical representation.
 * It is attached to one Lifeline, the event occurrence "duration" along 
 * the lifeline is defined by two event occurrences 
 * 
 * @see org.eclipse.hyades.uml2sd.ui.core.Lifeline Lifeline for more event occurence details
 * @author sveyrier
 *
 */
public class BasicExecutionOccurrence extends GraphNode {
	
	protected Lifeline	lifeline		= null;
	protected int 		startOccurrence = 0;
	protected int 		endOccurrence 	= 0;

	public int getX()
	{
		if (lifeline==null)
			return 0;
		return lifeline.getX() + Metrics.getLifelineWidth()/2-Metrics.EXECUTION_OCCURRENCE_WIDTH/2;
	}

	public int getY()
	{
		if (lifeline==null)
			return 0;
		return lifeline.getY() + lifeline.getHeight() + 
		(Metrics.getMessageFontHeigth()+Metrics.getMessagesSpacing()) * startOccurrence;
	}

	public int getWidth()
	{
		if (lifeline==null)
			return 0;
		return Metrics.EXECUTION_OCCURRENCE_WIDTH;
	}

	
	public int getHeight()
	{
		if (lifeline==null)
			return 0;
		return ((Metrics.getMessageFontHeigth()+Metrics.getMessagesSpacing())) * (endOccurrence-startOccurrence);
	}	
	
	public boolean contains(int _x, int _y)
	{
		int x = getX();
		int y = getY();
		int width = getWidth();
		int height = getHeight();
		
		if (Frame.contains(x, y, width, height,_x, _y))
		{
			return true;
		}
		return false;
	}
	
	public String getName()
	{
		if (super.getName() == null || super.getName().equals("")) //$NON-NLS-1$
			return lifeline.getToolTipText();
		else return super.getName();
	}
	
	
	/**
	 * Set the lifeline on which the execution occurrence appears. 
	 * @param theLifeline - the parent lifeline
	 */
	public void setLifeline (Lifeline theLifeline)
	{
		lifeline = theLifeline;
	}
	
	/**
	 * Get the lifeline on which the execution occurrence appears. 
	 * @return - the parent lifeline
	 */
	public Lifeline getLifeline ()
	{
		return lifeline;
	}
	
	/**
	 * Get the execution start event occurrence
	 * @return the start event occurrence to set
	 */
	public int getStartOccurrence ()
	{
		return startOccurrence;
	}
	
	/**
	 * Set the execution end event occurrence
	 * @return the end event occurrence to set
	 */
	public int getEndOccurrence ()
	{
		return endOccurrence;
	}

	/**
	 * Set the execution start event occurrence
	 * @param occurrence the start event occurrence to set
	 */
	public void setStartOccurrence (int occurrence)
	{
		startOccurrence = occurrence;
	}
	
	/**
	 * Set the execution end event occurrence
	 * @param occurrence the end event occurrence to set
	 */
	public void setEndOccurrence (int occurrence)
	{
		endOccurrence = occurrence;
	}

	public void draw (IGC context)
	{
		int x = getX();
		int y = getY();
		int width = getWidth();
		int height = getHeight();
		IColor tempFillColor = null, tempStrokeColor = null;
		IImage tempImage = null;

		//The execution occurrence is selected
		//if the owning lifeline is selected
		if (lifeline.isSelected()||isSelected())
		{
			context.setBackground(Frame.getUserPref().getBackGroundColorSelection());
			context.setForeground(Frame.getUserPref().getForeGroundColorSelection());
		}
		else 
		{
			tempFillColor = setUnselectedFillColor(context);
		}
		if (Frame.getUserPref().useGradienColor())
			context.fillGradientRectangle(x, y, width, height,false);
		else context.fillRectangle(x, y, width, height);
		tempStrokeColor = setUnselectedStrokeColor(context);
		context.drawRectangle(x, y, width, height);	
		if (tempFillColor != null)
		{
			tempFillColor.dispose();
			tempFillColor = null;
		}
		if (tempStrokeColor != null)
		{
			tempStrokeColor.dispose();
			tempStrokeColor = null;
		}
	}

	/**
	 * Rewrite this method in your extension in order to support customized fill colors
	 * @param context
	 * @return IColor
	 */
	protected IColor setUnselectedFillColor(IGC context) {
		if (Frame.getUserPref().useGradienColor())
		{
			context.setGradientColor(Frame.getUserPref().getBackGroundColor(ISDPreferences.PREF_EXEC));
			context.setBackground(Frame.getUserPref().getBackGroundColor(ISDPreferences.PREF_FRAME));
		}
		else context.setBackground(Frame.getUserPref().getBackGroundColor(ISDPreferences.PREF_EXEC));
		return null;
	}

	/**
	 * Rewrite this method in your extension in order to support customized stroke colors
	 * @param context
	 * @return IColor
	 */
	protected IColor setUnselectedStrokeColor(IGC context) {
		context.setForeground(Frame.getUserPref().getForeGroundColor(ISDPreferences.PREF_EXEC));
		return null;
	}

}
