/**********************************************************************
 * Copyright (c) 2004 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.uml2sd.ztest;

import org.eclipse.hyades.uml2sd.ui.core.AsyncMessage;
import org.eclipse.hyades.uml2sd.ui.core.ExecutionOccurrence;
import org.eclipse.hyades.uml2sd.ui.core.Frame;
import org.eclipse.hyades.uml2sd.ui.core.Lifeline;
import org.eclipse.hyades.uml2sd.ui.core.SyncMessageReturn;
import org.eclipse.hyades.uml2sd.ui.view.SDView;

/**
 * @author sveyrier
 *
 */
public class testLogLoader {

	public SDView v;
	
	public testLogLoader()
	{
	}
	
	public void setViewer(SDView v_)
	{
		v = v_;
		final Frame testFrame = new Frame();
		testFrame.setName("Sequence Diagram"); //$NON-NLS-1$
		Lifeline lifelines[] = new Lifeline[12];
		lifelines[0]=new Lifeline();
		lifelines[0].setName("LifeLine " + 0); //$NON-NLS-1$
		testFrame.addLifeLine(lifelines[0]);
		AsyncMessage as = new AsyncMessage();
		as.setStartLifeline(lifelines[0]);
		as.setEndLifeline(lifelines[0]);
		as.setStartOccurrence(2);
		as.setEndOccurrence(2);
		testFrame.addMessage(as);
		ExecutionOccurrence exec = new ExecutionOccurrence();
		exec.setStartOccurrence(2);
		exec.setEndOccurrence(2);
		exec.setStrokeColor(255, 0, 0);
		lifelines[0].addExecution(exec);
		as = new AsyncMessage();
		as.setStartLifeline(lifelines[0]);
		as.setEndLifeline(lifelines[0]);
		as.setStartOccurrence(4);
		as.setEndOccurrence(5);
		testFrame.addMessage(as);
		exec = new ExecutionOccurrence();
		exec.setStartOccurrence(2);
		exec.setEndOccurrence(17);
		exec.setFillColor(255, 0, 0);
		exec.setName("top to bottom");//$NON-NLS-1$
		lifelines[0].addExecution(exec);
		exec = new ExecutionOccurrence();
		exec.setStartOccurrence(16);
		exec.setEndOccurrence(17);
		exec.setFillColor(255, 0, 0);
		exec.setName("top to bottom");//$NON-NLS-1$
		lifelines[0].addExecution(exec);
		for (int i = 1; i < lifelines.length; i++) {
			lifelines[i]=new Lifeline();
			lifelines[i].setName("LifeLine " + i); //$NON-NLS-1$
			testFrame.addLifeLine(lifelines[i]);
			for (int j = 1; j < 50; j += 2) {
				SyncMessageReturn mn = new SyncMessageReturn();
				lifelines[i].setCurrentEventOccurrence(j);
				mn.setStartLifeline(lifelines[i]);
				mn.setName("msg "+i+":"+j); //$NON-NLS-1$ //$NON-NLS-2$
				testFrame.addMessage(mn);
				exec = new ExecutionOccurrence();
				exec.setStartOccurrence(j);
				exec.setEndOccurrence(j+1);
//				if (i == lifelines.length-1) 
				{
					exec.setStartTime(j);
					exec.setEndTime(j);//+1.0);
				}
				lifelines[i].addExecution(exec);
			}
		}
		v.setFrame(testFrame);
	}

}
