/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.util.DeleteUtil;
import org.eclipse.hyades.ui.extension.INavigatorItem;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.hyades.trace.internal.ui.*;

/*
* CONTEXT_ID delt0000 for delete popup action
*/

public class DeleteAction
	extends SelectionProviderAction
	implements ISelectionChangedListener {
	private INavigator fViewer;

	private ArrayList deletedPaths = new ArrayList();

	class DeleteResourceDialog extends MessageDialog {

		private boolean deleteContent = false;
		private Button radio1;
		private Button radio2;

		DeleteResourceDialog(Shell parentShell) {
			super(
				parentShell,
				UIPlugin.getResourceString("TRACE_MSG"),
				null,
			// accept the default window icon
			UIPlugin.getResourceString("CONFIRM_DEL_MSG"),
				MessageDialog.QUESTION,
				new String[] {
					IDialogConstants.YES_LABEL,
					IDialogConstants.NO_LABEL },
				0);
			// yes is the default
		}

		protected Control createCustomArea(Composite parent) {
			Composite composite = new Composite(parent, SWT.NONE);
			composite.setLayout(new GridLayout());
			radio1 = new Button(composite, SWT.RADIO);
			radio1.addSelectionListener(selectionListener);
			String text1 =
				UIPlugin.getResourceString("STR_DELETE_RESOURCE_PATH");
			radio1.setText(text1);

			radio2 = new Button(composite, SWT.RADIO);
			radio2.addSelectionListener(selectionListener);
			String text2 =
				UIPlugin.getResourceString("STR_NOT_DELETE_RESOURCE");
			radio2.setText(text2);

			// set initial state
			radio1.setSelection(deleteContent);
			radio2.setSelection(!deleteContent);

			return composite;
		}

		private SelectionListener selectionListener = new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				Button button = (Button) e.widget;
				if (button.getSelection()) {
					deleteContent = (button == radio1);
				}
			}
		};

		public boolean getDeleteContent() {
			return deleteContent;
		}
	}

	public DeleteAction(INavigator viewer) {
		super(viewer.getViewer(), UIPlugin.getResourceString("DELETE"));
		setDescription(UIPlugin.getResourceString("DELETE_RESOURCE"));
		setToolTipText(UIPlugin.getResourceString("DELETE_OBJECT_TOOLTIP"));

		ISharedImages images = UIPlugin.getDefault().getWorkbench().getSharedImages();
		setImageDescriptor(images.getImageDescriptor(ISharedImages.IMG_TOOL_DELETE));

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			this,
			UIPlugin.getPluginId() + ".delt0000");

		fViewer = viewer;
	}
	/**
	 * Insert the method's description here.
	 * Creation date: (11/07/2000 12:55:01 PM)
	 * @param process com.ibm.etools.perftrace.TRCAgent
	 */
	/**
	 *The user has invoked this action
	 */
	public void run() {
		Object[] fSelections = ((IStructuredSelection)fViewer.getViewer().getSelection()).toArray();
		if (fSelections == null || fSelections.length == 0)
			return;

		Shell shell = Display.getCurrent().getActiveShell();
		for (int i = 0; i < fSelections.length; i++) {
			Object sel = fSelections[i];
			if (!validForDelete(sel))
				return;
		}

		DeleteResourceDialog dlg = new DeleteResourceDialog(fViewer.getViewSite().getShell());
		if (dlg.open() != 0)
			return;

		final boolean deleteContents = dlg.getDeleteContent();

		deletedPaths.clear();

		for (int i = 0; i < fSelections.length; i++) {
			final Object sel = fSelections[i];

			if (sel != null) {
				org
					.eclipse
					.swt
					.custom
					.BusyIndicator
					.showWhile(null, new Runnable() {
					public void run() {
						if (sel instanceof IResource) {
							if (!containsPath(((IResource) sel)
								.getFullPath())) {
								DeleteUtil.deleteResource(
									(IResource) sel,
									deleteContents);
								deletedPaths.add(
									((IResource) sel).getFullPath());
							}
						} else if (sel instanceof TRCMonitor)
							DeleteUtil.deleteMonitor(
								(TRCMonitor) sel,
								true,
								deleteContents);
						else if (sel instanceof TRCNode)
							DeleteUtil.deleteNode(
								(TRCNode) sel,
								true,
								deleteContents);
						else if (sel instanceof TRCAgentProxy)
							DeleteUtil.deleteAgent(
								(TRCAgentProxy) sel,
								true,
								deleteContents);
						else if (sel instanceof TRCProcessProxy)
							DeleteUtil.deleteProcess(
								(TRCProcessProxy) sel,
								true,
								deleteContents);
						else if (sel instanceof CorrelationContainerProxy)
							DeleteUtil.deleteCorrelationContainer(
									(CorrelationContainerProxy) sel,
									true,
									deleteContents);
						else if (sel instanceof INavigatorItem)
							((INavigatorItem)sel).delete(true, deleteContents);
							
					}
				});
			}
		}

		fSelections = null;
		deletedPaths.clear();
		shell = null;

		ProfileEvent event = new ProfileEvent();
		event.setSource(null);
		event.setType(ProfileEvent.CLEAN_UP);
		UIPlugin.getDefault().notifyProfileEventListener(event);

		event = UIPlugin.getDefault().getProfileEvent();
		if(event==null)
			event = new ProfileEvent();
		event.setSource(null);
		event.setType(ProfileEvent.UNSPECIFIED);
		UIPlugin.getDefault().notifyProfileEventListener(event);
		
		if(fViewer instanceof PDProjectExplorer){
			((PDProjectExplorer)fViewer).clear();	
		}
	}

	/**
	 * Method containsPath.
	 * @param innerPath
	 * @return boolean
	 */
	private boolean containsPath(IPath innerPath) {
		for (Iterator iter = deletedPaths.iterator(); iter.hasNext();) {
			IPath path = (IPath) iter.next();

			if (path.isPrefixOf(innerPath))
				return true;
		}

		return false;
	}

	private boolean checkContainer(IContainer container, int deep) {
		if (deep != 0) {
			if (deep != -1)
				--deep;
			try {
				IResource[] resources = container.members();
				for (int j = 0; j < resources.length; j++) {
					if (resources[j] instanceof IContainer) {
						if (!checkContainer((IContainer) resources[j], deep))
							return false;
					}
				}
			} catch (CoreException e) {
				e.printStackTrace();
				return false;
			}
		}
		ArrayList monitors = PDContentProvider.getMonitors(container);
		return true;
	}

	private boolean validForDelete(Object sel) {
		if (sel != null) {
			if (sel instanceof IContainer) {
				return checkContainer((IContainer) sel, -1);
			} else if (sel instanceof TRCAgentProxy) {
				if (!checkAgentState((TRCAgentProxy) sel))
					return false;
			} else if (sel instanceof TRCProcessProxy) {
				if (!checkAgentsState(((TRCProcessProxy) sel)
					.getAgentProxies()))
					return false;
			}
			return true;
		} else
			return true;
	}

	/**
	 * Method checkAgentState.
	 * @param eList
	 */
	private boolean checkAgentsState(EList eList) {
		for (Iterator iter = eList.iterator(); iter.hasNext();) {
			TRCAgentProxy agent = (TRCAgentProxy) iter.next();
			if (agent.eIsProxy())
				continue;
			if (!checkAgentState(agent))
				return false;
		}
		return true;
	}

	private boolean checkAgentState(TRCAgentProxy a) {
		if ((a.isActive() && (a.isAttached() || a.isMonitored())) || a.isCollectionData()) {
			treatActiveAgentWhenDelete(a);
			return false;
		}
		return true;
	}

	private void treatActiveAgentWhenDelete(TRCAgentProxy a) {
		String text = UIPlugin.getResourceString("DELETE_ACTIVE_AGENT_ERROR_");
		text = HyadesUtil.change(text, "%1", a.getName());

        final Shell shell = Display.getDefault().getActiveShell();
		if (shell != null) {
			final Status err =
				new Status(
					Status.WARNING,
					ResourcesPlugin.PI_RESOURCES,
					IResourceStatus.INTERNAL_ERROR,
					text,
					null);
			shell.getDisplay().asyncExec(new Runnable() {
				public void run() {
					ErrorDialog.openError(
						shell,
						UIPlugin.getResourceString("TRACE_MSG"),
						UIPlugin.getResourceString("DELETE_FILE_ERROR_TITLE"),
						err);
				}
			});
		}
	}

	/**
	 * Let target decide.
	 */
	public void selectionChanged(IStructuredSelection selection) {
	}
	
    /**
     * 
     */
	public void dispose() {

		super.dispose();

		fViewer = null;
		if(deletedPaths!=null)	
			deletedPaths.clear();
		deletedPaths = null;
	}

}
